/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.SporeRecreatorConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.ItemHandlerUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class SporesRecreatorTile
extends IndustrialProcessingTile<SporesRecreatorTile> {
    private int getPowerPerTick;
    @Save
    private SidedFluidTankComponent<SporesRecreatorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("water", SporeRecreatorConfig.maxWaterTankSize, 31, 20, 0).setColor(DyeColor.CYAN).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)Fluids.WATER) || fluidStack.getFluid().isSame((Fluid)Fluids.LAVA));
    @Save
    private SidedInventoryComponent<SporesRecreatorTile> input;
    @Save
    private SidedInventoryComponent<SporesRecreatorTile> output;

    public SporesRecreatorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.SPORES_RECREATOR, 79, 40, blockPos, blockState);
        this.addTank(this.tank);
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("input", 53, 22, 3, 1).setColor(DyeColor.BLUE).setRange(1, 3).setComponentHarness((IComponentHarness)this).setInputFilter((stack, integer) -> stack.is(Tags.Items.MUSHROOMS) || stack.getItem().equals(Items.CRIMSON_FUNGUS) || stack.getItem().equals(Items.WARPED_FUNGUS)).setOutputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.input);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 110, 22, 9, 2).setColor(DyeColor.ORANGE).setRange(3, 3).setComponentHarness((IComponentHarness)this).setInputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.output);
        this.getPowerPerTick = SporeRecreatorConfig.powerPerTick;
    }

    @Override
    public boolean canIncrease() {
        return !ItemHandlerUtil.getFirstItem(this.input).isEmpty() && this.tank.getFluidAmount() >= 100 && (ItemHandlerUtil.getFirstItem(this.input).is(Tags.Items.MUSHROOMS) ? this.tank.getFluid().getFluid().isSame((Fluid)Fluids.WATER) : this.tank.getFluid().getFluid().isSame((Fluid)Fluids.LAVA)) && ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((ItemLike)ItemHandlerUtil.getFirstItem(this.input).getItem(), 2), (boolean)true).isEmpty();
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ItemStack outputStack = new ItemStack((ItemLike)ItemHandlerUtil.getFirstItem(this.input).getItem(), 2);
            this.tank.drainForced(100, IFluidHandler.FluidAction.EXECUTE);
            ItemHandlerUtil.getFirstItem(this.input).shrink(1);
            ItemHandlerHelper.insertItem(this.output, (ItemStack)outputStack, (boolean)false);
        };
    }

    protected EnergyStorageComponent<SporesRecreatorTile> createEnergyStorage() {
        return new EnergyStorageComponent(SporeRecreatorConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return this.getPowerPerTick;
    }

    @Nonnull
    public SporesRecreatorTile getSelf() {
        return this;
    }
}

