/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MovementUtils {
    public static void handleConveyorMovement(Entity entity, Direction direction, BlockPos pos, ConveyorBlock.EnumType type) {
        if (entity instanceof Player && entity.isCrouching()) {
            return;
        }
        if ((double)(entity.blockPosition().getY() - pos.getY()) > 0.3 && !type.isVertical()) {
            return;
        }
        VoxelShape collision = entity.level().getBlockState(pos).getCollisionShape((BlockGetter)entity.level(), pos, CollisionContext.empty()).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (!type.isVertical() && collision.toAabbs().stream().noneMatch(axisAlignedBB -> axisAlignedBB.inflate(0.01).intersects(entity.getBoundingBox()))) {
            return;
        }
        double speed = 0.2;
        if (type.isFast()) {
            speed *= 2.0;
        }
        Vec3 vec3d = new Vec3(speed * (double)direction.getNormal().getX(), speed * (double)direction.getNormal().getY(), speed * (double)direction.getNormal().getZ());
        if (type.isVertical()) {
            vec3d = vec3d.add(0.0, type.isUp() ? 0.258 : -0.05, 0.0);
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            if (entity.getX() - (double)pos.getX() < 0.45) {
                vec3d = vec3d.add(0.08, 0.0, 0.0);
            } else if (entity.getX() - (double)pos.getX() > 0.55) {
                vec3d = vec3d.add(-0.08, 0.0, 0.0);
            }
        }
        if (direction == Direction.EAST || direction == Direction.WEST) {
            if (entity.getZ() - (double)pos.getZ() < 0.45) {
                vec3d = vec3d.add(0.0, 0.0, 0.08);
            } else if (entity.getZ() - (double)pos.getZ() > 0.55) {
                vec3d = vec3d.add(0.0, 0.0, -0.08);
            }
        }
        entity.setDeltaMovement(vec3d.x, vec3d.y != 0.0 ? vec3d.y : entity.getDeltaMovement().y, vec3d.z);
    }

    public static void handleConveyorMovement(Entity entity, Direction direction, BlockPos pos, ConveyorBlock.EnumType type, List<Entity> filter) {
        if (filter.contains(entity)) {
            return;
        }
        MovementUtils.handleConveyorMovement(entity, direction, pos, type);
    }
}

