/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.entity.InfinityLauncherProjectileEntity;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.FacingUtil;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class ItemInfinityLauncher
extends ItemInfinity {
    public static int POWER_CONSUMPTION = 100000;
    public static int FUEL_CONSUMPTION = 30;
    public static String PLUNGER_NBT = "Plunger";

    public ItemInfinityLauncher(TitaniumTab group) {
        super("infinity_launcher", group, new Item.Properties().stacksTo(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
        this.disableArea();
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        super.addNbt(stack, power, fuel, special);
        stack.set(IFAttachments.PLUNGER_ACTION, (Object)PlungerAction.RELEASE);
    }

    @Override
    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (!stack.has(IFAttachments.PLUNGER_ACTION)) {
            stack.set(IFAttachments.PLUNGER_ACTION, (Object)PlungerAction.RELEASE);
        }
    }

    @Override
    public void addTooltipDetails(BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        PlungerAction action = this.getPlungerAction(stack);
        tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.action").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)("text.industrialforegoing.launcher." + action.name().toLowerCase(Locale.ROOT))).withStyle(action.getColor())));
    }

    public PlungerAction getPlungerAction(ItemStack stack) {
        return (PlungerAction)((Object)stack.get(IFAttachments.PLUNGER_ACTION));
    }

    public void setPlungerAction(ItemStack stack, PlungerAction plungerAction) {
        stack.set(IFAttachments.PLUNGER_ACTION, (Object)plungerAction);
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 36000;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.UNBREAKING);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (!playerIn.isShiftKeyDown()) {
            playerIn.startUsingItem(handIn);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        int time;
        float velo;
        if (entityLiving instanceof Player && !((double)(velo = ItemInfinityLauncher.getArrowVelocity(time = this.getUseDuration(stack, entityLiving) - timeLeft)) < 0.1) && this.enoughFuel(stack)) {
            Player playerentity = (Player)entityLiving;
            playerentity.getCooldowns().addCooldown((Item)this, 20);
            if (!worldIn.isClientSide) {
                InfinityLauncherProjectileEntity abstractarrowentity = new InfinityLauncherProjectileEntity(worldIn, (LivingEntity)playerentity, this.getPlungerAction(stack), ItemInfinityLauncher.getSelectedTier(stack).getRadius(), stack);
                abstractarrowentity.shootFromRotation((Entity)playerentity, playerentity.xRotO, playerentity.yRotO, 0.0f, velo * 3.0f, 1.0f);
                if (velo == 1.0f) {
                    abstractarrowentity.setCritArrow(true);
                }
                if (EnchantmentHelper.getItemEnchantmentLevel((Holder)worldIn.registryAccess().holderOrThrow(Enchantments.FLAME), (ItemStack)stack) > 0) {
                    abstractarrowentity.setSharedFlagOnFire(true);
                }
                this.consumeFuel(stack);
                abstractarrowentity.pickup = AbstractArrow.Pickup.DISALLOWED;
                worldIn.addFreshEntity((Entity)abstractarrowentity);
            }
            worldIn.playSound((Player)null, playerentity.getX(), playerentity.getY(), playerentity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.random.nextFloat() * 0.4f + 1.2f) + velo * 0.5f);
            playerentity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        List<IFactory<? extends IScreenAddon>> factory = super.getScreenAddons(stack);
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52, 14, 14, FacingUtil.Sideness.RIGHT).setId(4))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52, 14, 14, FacingUtil.Sideness.LEFT).setId(5))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56, false){

            public String getText() {
                PlungerAction action = ItemInfinityLauncher.this.getPlungerAction((ItemStack)stack.get());
                return String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.action").withStyle(ChatFormatting.GRAY).getString() + String.valueOf(action.getColor()) + Component.translatable((String)("text.industrialforegoing.launcher." + action.name().toLowerCase(Locale.ROOT))).withStyle(action.getColor()).getString();
            }
        }));
        return factory;
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        ItemStack stack = playerEntity.getItemInHand(InteractionHand.MAIN_HAND);
        PlungerAction plungerAction = this.getPlungerAction(stack);
        if (id == 4) {
            this.setPlungerAction(stack, PlungerAction.getFromId(plungerAction.getId() + 1));
        }
        if (id == 5) {
            this.setPlungerAction(stack, PlungerAction.getFromId(plungerAction.getId() - 1));
        }
    }

    @Override
    public void registerRecipe(RecipeOutput consumer) {
        DissolutionChamberRecipe.createRecipe(consumer, "infinity_launcher", new DissolutionChamberRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.BOW)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModuleTool.MOB_IMPRISONMENT_TOOL.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())}), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD)), new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, Optional.of(new ItemStack((ItemLike)this)), Optional.empty()));
    }

    public static enum PlungerAction implements StringRepresentable
    {
        RELEASE(0, ChatFormatting.GREEN),
        CAPTURE(1, ChatFormatting.GOLD),
        DAMAGE(2, ChatFormatting.RED);

        public static final Codec<PlungerAction> CODEC;
        private final int id;
        private final ChatFormatting color;

        private PlungerAction(int id, ChatFormatting color) {
            this.id = id;
            this.color = color;
        }

        public static PlungerAction getFromId(int id) {
            if (id < 0) {
                return DAMAGE;
            }
            for (PlungerAction value : PlungerAction.values()) {
                if (value.id != id) continue;
                return value;
            }
            return RELEASE;
        }

        public int getId() {
            return this.id;
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromValues(PlungerAction::values);
        }
    }
}

