/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.FilteredTransporterType;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.proxy.client.render.TransporterTESR;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.TileUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class TransporterItemType
extends FilteredTransporterType<ItemStack, IItemHandler> {
    public static final int QUEUE_SIZE = 6;
    private HashMap<Direction, List<ItemStack>> queue = new HashMap();
    private int extractSlot = 0;

    public TransporterItemType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
        for (Direction value : Direction.values()) {
            while (this.queue.computeIfAbsent(value, direction -> new ArrayList()).size() < 6) {
                this.queue.get(value).add(0, ItemStack.f_41583_);
            }
            if (this.queue.size() <= 6) continue;
            this.queue.get(value).remove(this.queue.get(value).size() - 1);
        }
    }

    @Override
    public RegulatorFilter<ItemStack, IItemHandler> createFilter() {
        return new RegulatorFilter<ItemStack, IItemHandler>(20, 20, 5, 3, 16, 64, 8192, ""){

            @Override
            public int matches(ItemStack stack, IItemHandler itemHandler, boolean isRegulated) {
                if (this.isEmpty()) {
                    return stack.m_41613_();
                }
                int amount = 0;
                if (isRegulated) {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        if (!ItemStack.m_41656_((ItemStack)itemHandler.getStackInSlot(i), (ItemStack)stack)) continue;
                        amount += itemHandler.getStackInSlot(i).m_41613_();
                    }
                }
                for (IFilter.GhostSlot slot : this.getFilter()) {
                    if (!ItemStack.m_41656_((ItemStack)slot.getStack(), (ItemStack)stack)) continue;
                    int maxAmount = isRegulated ? slot.getAmount() : Integer.MAX_VALUE;
                    int returnAmount = Math.min(stack.m_41613_(), maxAmount - amount);
                    if (returnAmount <= 0) continue;
                    return returnAmount;
                }
                return 0;
            }
        };
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getSpeed();
        if (!this.getLevel().f_46443_ && (float)this.getLevel().m_46467_() % Math.max(1.0f, 4.0f - speed) == 0.0f) {
            IBlockContainer container = this.getContainer();
            if (this.getAction() == TransporterTypeFactory.TransporterAction.EXTRACT && container instanceof TransporterTile) {
                for (Direction direction : ((TransporterTile)container).getTransporterTypeMap().keySet()) {
                    TransporterType transporterType = ((TransporterTile)container).getTransporterTypeMap().get(direction);
                    if (!(transporterType instanceof TransporterItemType) || transporterType.getAction() != TransporterTypeFactory.TransporterAction.INSERT) continue;
                    TileUtil.getTileEntity((BlockGetter)this.getLevel(), (BlockPos)this.getPos().m_121945_(this.getSide())).ifPresent(tileEntity -> tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, this.getSide().m_122424_()).ifPresent(origin -> TileUtil.getTileEntity((BlockGetter)this.getLevel(), (BlockPos)this.getPos().m_121945_(direction)).ifPresent(otherTile -> otherTile.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).ifPresent(destination -> {
                        if (this.extractSlot >= origin.getSlots() || origin.getStackInSlot(this.extractSlot).m_41619_() || !this.filter(this.getFilter(), this.isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)origin, false) || !this.filter(((TransporterItemType)transporterType).getFilter(), ((TransporterItemType)transporterType).isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)destination, ((TransporterItemType)transporterType).isRegulated())) {
                            this.findSlot((IItemHandler)origin, ((TransporterItemType)transporterType).getFilter(), ((TransporterItemType)transporterType).isWhitelist(), (IItemHandler)destination, ((TransporterItemType)transporterType).isRegulated());
                        }
                        if (this.extractSlot >= origin.getSlots()) {
                            return;
                        }
                        if (!origin.getStackInSlot(this.extractSlot).m_41619_()) {
                            int amount = (int)(1.0f * this.getEfficiency());
                            ItemStack extracted = origin.extractItem(this.extractSlot, amount, true);
                            int simulatedAmount = ((TransporterItemType)transporterType).getFilter().matches(extracted, (IItemHandler)destination, ((TransporterItemType)transporterType).isRegulated());
                            if (!extracted.m_41619_() && this.filter(this.getFilter(), this.isWhitelist(), extracted, (IItemHandler)origin, false) && this.filter(((TransporterItemType)transporterType).getFilter(), ((TransporterItemType)transporterType).isWhitelist(), origin.getStackInSlot(this.extractSlot), (IItemHandler)destination, ((TransporterItemType)transporterType).isRegulated()) && simulatedAmount > 0) {
                                ItemStack returned = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)extracted, (boolean)true);
                                if (returned.m_41619_() || amount - returned.m_41613_() > 0) {
                                    extracted = origin.extractItem(this.extractSlot, returned.m_41619_() ? simulatedAmount : simulatedAmount - returned.m_41613_(), false);
                                    ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)extracted, (boolean)false);
                                    ((TransporterItemType)transporterType).addTransferedStack(this.getSide(), extracted);
                                } else {
                                    ++this.extractSlot;
                                    if (this.extractSlot >= origin.getSlots()) {
                                        this.extractSlot = 0;
                                    }
                                }
                            }
                        }
                        container.requestSync();
                    }))));
                }
            }
        }
    }

    private boolean filter(RegulatorFilter<ItemStack, IItemHandler> filter, boolean whitelist, ItemStack stack, IItemHandler handler, boolean isRegulated) {
        int accepts = filter.matches(stack, handler, isRegulated);
        if (whitelist && filter.isEmpty()) {
            return false;
        }
        return filter.isEmpty() != (whitelist == accepts > 0);
    }

    @Override
    public void updateClient() {
        super.updateClient();
        for (Direction value : Direction.values()) {
            while (this.queue.computeIfAbsent(value, direction -> new ArrayList()).size() < 6) {
                this.queue.get(value).add(0, ItemStack.f_41583_);
            }
            this.queue.get(value).add(0, ItemStack.f_41583_);
            while (this.queue.get(value).size() > 6) {
                this.queue.get(value).remove(this.queue.get(value).size() - 1);
            }
        }
    }

    private void findSlot(IItemHandler itemHandler, RegulatorFilter<ItemStack, IItemHandler> otherFilter, boolean otherWhitelist, IItemHandler otherItemHandler, boolean otherRegulated) {
        for (int i = this.extractSlot; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).m_41619_() || !this.filter(this.getFilter(), this.isWhitelist(), itemHandler.getStackInSlot(i), itemHandler, false) || !this.filter(otherFilter, otherWhitelist, itemHandler.getStackInSlot(i), otherItemHandler, otherRegulated)) continue;
            this.extractSlot = i;
            return;
        }
        this.extractSlot = 0;
    }

    public void addTransferedStack(Direction direction, ItemStack stack) {
        this.syncRender(direction, stack.serializeNBT());
    }

    @Override
    public void handleRenderSync(Direction origin, CompoundTag compoundNBT) {
        this.queue.computeIfAbsent(origin, direction -> new ArrayList()).add(0, ItemStack.m_41712_((CompoundTag)compoundNBT));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, PoseStack stack, int combinedOverlayIn, MultiBufferSource buffer, float frame, Level level) {
        super.renderTransfer(pos, direction, step, stack, combinedOverlayIn, buffer, frame, level);
        if (step < this.queue.computeIfAbsent(direction, v -> new ArrayList()).size()) {
            float scale = 0.1f;
            stack.m_85841_(scale, scale, scale);
            ItemStack itemStack = this.queue.get(direction).get(step);
            if (!itemStack.m_41619_()) {
                Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.NONE, 0xF000F0, combinedOverlayIn, stack, buffer, level, 0);
            } else {
                stack.m_85836_();
                stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
                stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                VertexConsumer buffer1 = buffer.m_6299_(TransporterTESR.TYPE);
                float pX1 = 1.0f;
                float u = 1.0f;
                float pX2 = 0.0f;
                float u2 = 0.0f;
                Color CLOSE = Color.CYAN;
                Color FAR = new Color(6815999);
                double ratio = ((double)step + 2.5) / 6.0;
                float xOffset = -0.75f;
                float yOffset = -0.0f;
                float zOffset = -0.75f;
                boolean alpha = true;
                stack.m_85841_(0.25f, 0.25f, 0.25f);
                float red = (float)((int)Math.abs(ratio * (double)FAR.getRed() + (1.0 - ratio) * (double)CLOSE.getRed())) / 256.0f;
                float green = (float)((int)Math.abs(ratio * (double)FAR.getGreen() + (1.0 - ratio) * (double)CLOSE.getGreen())) / 256.0f;
                float blue = (float)((int)Math.abs(ratio * (double)FAR.getBlue() + (1.0 - ratio) * (double)CLOSE.getBlue())) / 256.0f;
                Matrix4f matrix = stack.m_85850_().m_252922_();
                buffer1.m_252986_(matrix, pX2 + xOffset, yOffset, 0.0f + zOffset).m_85950_(red, green, blue, (float)alpha).m_7421_(u2, 0.0f).m_5752_();
                buffer1.m_252986_(matrix, pX1 + xOffset + 0.5f, yOffset, 0.0f + zOffset).m_85950_(red, green, blue, (float)alpha).m_7421_(u, 0.0f).m_5752_();
                buffer1.m_252986_(matrix, pX1 + xOffset + 0.5f, yOffset, 1.5f + zOffset).m_85950_(red, green, blue, (float)alpha).m_7421_(u, 1.0f).m_5752_();
                buffer1.m_252986_(matrix, pX2 + xOffset, yOffset, 1.5f + zOffset).m_85950_(red, green, blue, (float)alpha).m_7421_(u2, 1.0f).m_5752_();
                stack.m_85849_();
            }
        }
    }

    public static class Factory
    extends TransporterTypeFactory {
        public Factory() {
            super("item");
        }

        @Override
        public TransporterType create(IBlockContainer container, Direction face, TransporterTypeFactory.TransporterAction action) {
            return new TransporterItemType(container, this, face, action);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, TransporterTypeFactory.TransporterAction action) {
            return new ResourceLocation("industrialforegoing", "block/transporters/item_transporter_" + action.name().toLowerCase() + "_" + upgradeSide.m_7912_().toLowerCase());
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("industrialforegoing:block/transporters/item"), new ResourceLocation("industrialforegoing:block/base/bottom")});
        }

        @Override
        public boolean canBeAttachedAgainst(Level world, BlockPos pos, Direction face) {
            return TileUtil.getTileEntity((BlockGetter)world, (BlockPos)pos).map(tileEntity -> tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, face).isPresent()).orElse(false);
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "block/transporters/item_transporter_" + TransporterTypeFactory.TransporterAction.EXTRACT.name().toLowerCase() + "_" + Direction.NORTH.m_7912_().toLowerCase());
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem(), (int)2).m_126130_("IPI").m_126130_("GMG").m_126130_("ICI").m_206416_(Character.valueOf('I'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42584_).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41869_).m_176498_(consumer);
        }
    }
}

