/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.core.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.core.FluidExtractorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidExtractorTile
extends IndustrialAreaWorkingTile<FluidExtractorTile> {
    public static HashMap<DimensionType, HashMap<ChunkPos, HashMap<BlockPos, FluidExtractionProgress>>> EXTRACTION = new HashMap();
    private int maxProgress;
    private int powerPerOperation;
    private FluidExtractorRecipe currentRecipe;
    @Save
    private SidedFluidTankComponent<FluidExtractorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("latex", FluidExtractorConfig.maxLatexTankSize, 43, 20, 0).setColor(DyeColor.LIGHT_GRAY).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this);

    public FluidExtractorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleCore.FLUID_EXTRACTOR, RangeManager.RangeType.BEHIND, false, FluidExtractorConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.tank);
        this.maxProgress = FluidExtractorConfig.maxProgress;
        this.powerPerOperation = FluidExtractorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pos = this.getPointedBlockPos();
        if (this.isLoaded(pos) && !this.f_58857_.m_46859_(pos) && this.tank.getFluidAmount() < this.tank.getCapacity()) {
            if (this.currentRecipe == null || !this.currentRecipe.matches(this.f_58857_, pos) || this.currentRecipe.defaultRecipe) {
                this.currentRecipe = this.findRecipe(this.f_58857_, pos);
            }
            if (this.currentRecipe != null) {
                FluidExtractionProgress extractionProgress = EXTRACTION.computeIfAbsent(this.f_58857_.m_6042_(), dimensionType -> new HashMap()).computeIfAbsent(this.f_58857_.m_46745_(pos).m_7697_(), chunkPos -> new HashMap()).computeIfAbsent(pos, pos1 -> new FluidExtractionProgress(this.f_58857_));
                if (this.currentRecipe.output.getFluid().m_6212_((Fluid)ModuleCore.LATEX.getSourceFluid().get())) {
                    this.tank.fillForced(new FluidStack(this.currentRecipe.output.getFluid(), this.currentRecipe.output.getAmount() * (this.hasEnergy(this.powerPerOperation) ? 3 : 1)), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    this.tank.fillForced(this.currentRecipe.output.copy(), IFluidHandler.FluidAction.EXECUTE);
                }
                if (this.f_58857_.f_46441_.m_188500_() <= (double)this.currentRecipe.breakChance) {
                    extractionProgress.setProgress(extractionProgress.getProgress() + 1);
                }
                if (extractionProgress.getProgress() > 7) {
                    extractionProgress.setProgress(0);
                    this.f_58857_.m_46597_(pos, this.currentRecipe.result.m_49966_());
                    if (this.currentRecipe.output.getFluid().m_6212_((Fluid)ModuleCore.LATEX.getSourceFluid().get())) {
                        this.tank.fillForced(new FluidStack(this.currentRecipe.output.getFluid(), this.currentRecipe.output.getAmount() * (this.hasEnergy(this.powerPerOperation) ? 200 : 1)), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if (this.hasEnergy(this.powerPerOperation)) {
                    return new IndustrialWorkingTile.WorkAction(0.4f, this.powerPerOperation);
                }
                return new IndustrialWorkingTile.WorkAction(1.0f, 0);
            }
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    protected EnergyStorageComponent<FluidExtractorTile> createEnergyStorage() {
        return new EnergyStorageComponent(FluidExtractorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nullable
    public FluidExtractorRecipe findRecipe(Level world, BlockPos pos) {
        List recipeList = RecipeUtil.getRecipes((Level)world, (RecipeType)((RecipeType)ModuleCore.FLUID_EXTRACTOR_TYPE.get()));
        for (FluidExtractorRecipe recipe : recipeList) {
            if (recipe.defaultRecipe || !recipe.matches(world, pos)) continue;
            return recipe;
        }
        for (FluidExtractorRecipe recipe : recipeList) {
            if (!recipe.defaultRecipe || !recipe.matches(world, pos)) continue;
            return recipe;
        }
        return null;
    }

    @Nonnull
    public FluidExtractorTile getSelf() {
        return this;
    }

    public static class FluidExtractionProgress {
        private int progress = 0;
        private int breakID;

        public FluidExtractionProgress(Level world) {
            this.breakID = world.f_46441_.m_188502_();
        }

        public int getProgress() {
            return this.progress;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }

        public int getBreakID() {
            return this.breakID;
        }
    }
}

