/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.hrznstudio.titanium.recipe.serializer.GenericSerializer;
import com.hrznstudio.titanium.recipe.serializer.SerializableRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class LaserDrillFluidRecipe
extends SerializableRecipe {
    public static List<LaserDrillFluidRecipe> RECIPES = new ArrayList<LaserDrillFluidRecipe>();
    public static ResourceLocation EMPTY = new ResourceLocation("minecraft", "empty");
    public CompoundTag output;
    public LaserDrillRarity[] rarity;
    public int pointer = 0;
    public Ingredient catalyst;
    public ResourceLocation entity;
    private String modIdCondition;

    public static void init() {
        new LaserDrillFluidRecipe(new FluidStack((Fluid)Fluids.LAVA, 100), 1, EMPTY, new LaserDrillRarity(LaserDrillRarity.NETHER, new ResourceKey[0], 5, 20, 8));
        new LaserDrillFluidRecipe(new FluidStack((Fluid)ModuleCore.ETHER.getSourceFluid().get(), 10), 10, new ResourceLocation("minecraft", "wither"), new LaserDrillRarity(new ResourceKey[0], new ResourceKey[0], -64, 256, 8));
        new LaserDrillFluidRecipe("oil", LaserDrillFluidRecipe.createNBT("pneumaticcraft:oil", 50), 15, EMPTY, new LaserDrillRarity(LaserDrillRarity.OIL, new ResourceKey[0], 20, 60, 8)).setModIdCondition("pneumaticcraft");
    }

    public LaserDrillFluidRecipe(String name, CompoundTag output, Ingredient catalyst, ResourceLocation entity, LaserDrillRarity ... rarity) {
        super(new ResourceLocation("industrialforegoing", name));
        this.output = output;
        this.rarity = rarity;
        this.catalyst = catalyst;
        this.entity = entity;
        System.out.println(this.output);
        RECIPES.add(this);
    }

    public LaserDrillFluidRecipe(String name, CompoundTag output, int color, ResourceLocation entity, LaserDrillRarity ... rarity) {
        this(name, output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModuleCore.LASER_LENS[color].get()}), entity, rarity);
    }

    public LaserDrillFluidRecipe(FluidStack output, int color, ResourceLocation entity, LaserDrillRarity ... rarity) {
        this(ForgeRegistries.FLUIDS.getKey((Object)output.getFluid()).getPath(), output.writeToNBT(new CompoundTag()), color, entity, rarity);
    }

    public LaserDrillFluidRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(Container inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(Container inv, RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public GenericSerializer<? extends SerializableRecipe> getSerializer() {
        return (GenericSerializer)ModuleCore.LASER_DRILL_FLUID_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.LASER_DRILL_FLUID_TYPE.get();
    }

    public Pair<ICondition, IConditionSerializer> getOutputCondition() {
        if (this.modIdCondition != null) {
            return Pair.of((Object)new ModLoadedCondition(this.modIdCondition), (Object)ModLoadedCondition.Serializer.INSTANCE);
        }
        return null;
    }

    public void setModIdCondition(String modIdCondition) {
        this.modIdCondition = modIdCondition;
    }

    public static CompoundTag createNBT(String name, int amount) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("FluidName", name);
        nbt.putInt("Amount", amount);
        return nbt;
    }

    @Nullable
    public LaserDrillRarity getValidRarity(ResourceLocation biome, int height) {
        for (LaserDrillRarity laserDrillRarity : this.rarity) {
            if (laserDrillRarity.depth_max < height || laserDrillRarity.depth_min > height || !(laserDrillRarity.whitelist.length == 0 ? Arrays.stream(laserDrillRarity.blacklist).noneMatch(registryKey -> registryKey.location().equals((Object)biome)) : Arrays.stream(laserDrillRarity.whitelist).anyMatch(registryKey -> registryKey.location().equals((Object)biome)))) continue;
            return laserDrillRarity;
        }
        return null;
    }
}

