/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.model;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.client.model.ConveyorModelData;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Pair;

public class ConveyorBlockModel
extends BakedModelWrapper<BakedModel> {
    public static Cache<Pair<Pair<String, Pair<Direction, Direction>>, Direction>, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build();
    private Map<Direction, List<BakedQuad>> prevQuads = new HashMap<Direction, List<BakedQuad>>();

    public ConveyorBlockModel(BakedModel previousConveyor) {
        super(previousConveyor);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        if (state == null) {
            if (!this.prevQuads.containsKey(side)) {
                this.prevQuads.put(side, this.originalModel.getQuads(state, side, rand));
            }
            return this.prevQuads.get(side);
        }
        if (!this.prevQuads.containsKey(side)) {
            this.prevQuads.put(side, this.originalModel.getQuads(state, side, rand));
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>((Collection)this.prevQuads.get(side));
        if (extraData.has(ConveyorModelData.UPGRADE_PROPERTY)) {
            for (ConveyorUpgrade upgrade : ((ConveyorModelData)extraData.get(ConveyorModelData.UPGRADE_PROPERTY)).getUpgrades().values()) {
                if (upgrade == null) continue;
                List upgradeQuads = (List)CACHE.getIfPresent((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getName(), (Object)Pair.of((Object)upgrade.getSide(), (Object)((Direction)state.getValue((Property)ConveyorBlock.FACING)))), (Object)side));
                if (upgradeQuads == null) {
                    try {
                        BakedModel model = ModuleTransportStorage.CONVEYOR_UPGRADES_CACHE.get(upgrade.getFactory().getModel(upgrade.getSide(), (Direction)state.getValue((Property)ConveyorBlock.FACING)));
                        upgradeQuads = model.getQuads(state, side, rand, extraData, renderType);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    CACHE.put((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getName(), (Object)Pair.of((Object)upgrade.getSide(), (Object)((Direction)state.getValue((Property)ConveyorBlock.FACING)))), (Object)side), (Object)upgradeQuads);
                }
                if (upgradeQuads.isEmpty()) continue;
                quads.addAll(upgradeQuads);
            }
        }
        return quads;
    }
}

