/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class LaserDrillOreCategory
implements IRecipeCategory<LaserDrillOreRecipe> {
    private IGuiHelper guiHelper;

    public LaserDrillOreCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public Component getTitle() {
        return Component.literal((String)"Laser Drill Items");
    }

    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 0, 82, 26).addPadding(0, 60, 35, 35).build();
    }

    public IDrawable getIcon() {
        return null;
    }

    public RecipeType<LaserDrillOreRecipe> getRecipeType() {
        return IndustrialRecipeTypes.LASER_ORE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LaserDrillOreRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 36, 5).addIngredients(recipe.catalyst);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 5).addIngredients(recipe.output);
    }

    public void draw(LaserDrillOreRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int recipeWidth = 152;
        if (recipe.pointer > 0) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)Minecraft.getInstance().screen, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_LEFT), (int)0, (int)70);
        }
        if (recipe.pointer < recipe.rarity.length - 1) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)Minecraft.getInstance().screen, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_RIGHT), (int)137, (int)70);
        }
        ResourceLocation toasts = new ResourceLocation("textures/gui/toasts.png");
        int n = recipeWidth / 10 * 2;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.blit(toasts, n, 30 + (9 + 2) * 3, 216.0f, 0.0f, 20, 20, 256, 256);
        int n2 = recipeWidth / 10 * 7;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.blit(toasts, n2, 30 + (9 + 2) * 3, 216.0f, 0.0f, 20, 20, 256, 256);
        ResourceLocation icons = new ResourceLocation("forge", "textures/gui/icons.png");
        int n3 = recipeWidth / 10 * 7 + 1;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.blit(icons, n3, 30 + (9 + 2) * 3 + 3, 0, 16, 16, 16);
        String minY = Component.translatable((String)"text.industrialforegoing.miny").getString() + " " + recipe.rarity[recipe.pointer].depth_min;
        String maxY = Component.translatable((String)"text.industrialforegoing.maxy").getString() + " " + recipe.rarity[recipe.pointer].depth_max;
        String wight = Component.translatable((String)"text.industrialforegoing.weight").getString() + " " + recipe.rarity[recipe.pointer].weight;
        String biomes = Component.translatable((String)"text.industrialforegoing.biomes").getString();
        guiGraphics.drawString(Minecraft.getInstance().font, ChatFormatting.DARK_GRAY + minY, recipeWidth / 10, 30, 0, false);
        Font font = Minecraft.getInstance().font;
        String string = ChatFormatting.DARK_GRAY + wight;
        int n4 = recipeWidth / 10;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font, string, n4, 30 + (9 + 2), 0, false);
        guiGraphics.drawString(Minecraft.getInstance().font, ChatFormatting.DARK_GRAY + maxY, recipeWidth / 10 * 6, 30, 0, false);
        Font font2 = Minecraft.getInstance().font;
        String string2 = ChatFormatting.DARK_GRAY + ChatFormatting.UNDERLINE + biomes;
        int n5 = recipeWidth / 2 - Minecraft.getInstance().font.width(biomes) / 2;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font2, string2, n5, 30 + (9 + 2) * 2, 0, false);
    }

    public List<Component> getTooltipStrings(LaserDrillOreRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            return Collections.singletonList(Component.translatable((String)"text.industrialforegoing.button.jei.prev_rarity"));
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.length - 1) {
            return Collections.singletonList(Component.translatable((String)"text.industrialforegoing.button.jei.next_rarity"));
        }
        if (mouseX > 26.0 && mouseX < 46.0) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    ArrayList<Component> biomes = new ArrayList<Component>();
                    biomes.add((Component)Component.translatable((String)"text.industrialforegoing.tooltip.whitelisted_biomes").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (recipe.rarity[recipe.pointer].whitelist.length == 0) {
                        biomes.add((Component)Component.literal((String)"- Any"));
                    } else {
                        for (ResourceKey registryKey : recipe.rarity[recipe.pointer].whitelist) {
                            biomes.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)("biome." + registryKey.location().getNamespace() + "." + registryKey.location().getPath()))));
                        }
                    }
                    return biomes;
                }
            }
        }
        if (mouseX > 104.0 && mouseX < 124.0) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            if (mouseY > (double)(30 + (9 + 2) * 3)) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (mouseY < (double)(30 + (9 + 2) * 3 + 20)) {
                    ArrayList<Component> biomes = new ArrayList<Component>();
                    biomes.add((Component)Component.translatable((String)"text.industrialforegoing.tooltip.blacklisted_biomes").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (recipe.rarity[recipe.pointer].blacklist.length == 0) {
                        biomes.add((Component)Component.literal((String)"- None"));
                    } else {
                        for (ResourceKey registryKey : recipe.rarity[recipe.pointer].blacklist) {
                            biomes.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)("biome." + registryKey.location().getNamespace() + "." + registryKey.location().getPath()))));
                        }
                    }
                    return biomes;
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean handleInput(LaserDrillOreRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            --recipe.pointer;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.length - 1) {
            ++recipe.pointer;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return false;
    }
}

