/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.item.infinity.IInfinityDrillScreenAddons;
import com.buuz135.industrial.item.infinity.InfinityCapabilityProvider;
import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.capability.FluidHandlerScreenProviderItemStack;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.addon.TankScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.itemstack.ItemStackHarnessRegistry;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.PlayerInventoryFinder;
import com.hrznstudio.titanium.network.locator.instance.HeldStackLocatorInstance;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.FacingUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinity
extends IFCustomItem
implements MenuProvider,
IButtonHandler,
IInfinityDrillScreenAddons,
ISpecialCreativeTabItem {
    private final int powerConsumption;
    private final int biofuelConsumption;
    private final boolean usesDepth;
    private boolean usesArea;

    public ItemInfinity(String name, TitaniumTab group, Item.Properties builder, int powerConsumption, int biofuelConsumption, boolean usesDepth) {
        super(name, group, builder);
        this.powerConsumption = powerConsumption;
        this.biofuelConsumption = biofuelConsumption;
        this.usesDepth = usesDepth;
        this.usesArea = true;
    }

    public static long getPowerFromStack(ItemStack stack) {
        long power = 0L;
        if (stack.hasTag() && stack.getTag().contains("Energy")) {
            power = stack.getTag().getLong("Energy");
        }
        return power;
    }

    public void disableArea() {
        this.usesArea = false;
    }

    public String getFormattedArea(ItemStack stack, InfinityTier tier, int radius, boolean usesDepth) {
        int diameter = radius * 2 + 1;
        return diameter + "x" + diameter + "x" + (tier == InfinityTier.ARTIFACT || usesDepth ? diameter : 1);
    }

    public static InfinityTier getSelectedTier(ItemStack stack) {
        return stack.hasTag() && stack.getTag().contains("Selected") ? InfinityTier.valueOf(stack.getTag().getString("Selected")) : (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft());
    }

    public static boolean canCharge(ItemStack stack) {
        if (stack.hasTag() && stack.getTag().contains("CanCharge")) {
            return stack.getTag().getBoolean("CanCharge");
        }
        return true;
    }

    public void onCraftedBy(ItemStack stack, Level worldIn, Player playerIn) {
        super.onCraftedBy(stack, worldIn, playerIn);
        if (!stack.hasTag()) {
            this.addNbt(stack, 0L, 0, false);
        }
    }

    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.putLong("Energy", power);
        CompoundTag fluid = new CompoundTag();
        fluid.putString("FluidName", "biofuel");
        fluid.putInt("Amount", fuel);
        tagCompound.put("Fluid", (Tag)fluid);
        tagCompound.putBoolean("Special", special);
        tagCompound.putString("Selected", ((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getLeft())).name());
        tagCompound.putBoolean("CanCharge", true);
        stack.setTag(tagCompound);
    }

    public void addToTab(BuildCreativeModeTabContentsEvent event) {
        for (InfinityTier value : InfinityTier.values()) {
            event.accept(this.createStack(value.getPowerNeeded(), 0, false));
        }
        event.accept(this.createStack(InfinityTier.ARTIFACT.getPowerNeeded(), 1000000, true));
    }

    public ItemStack createStack(long power, int fuel, boolean special) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.addNbt(stack, power, fuel, special);
        return stack;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 50;
    }

    public UseAnim getUseAnimation(ItemStack p_77661_1_) {
        return UseAnim.BOW;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged && !oldStack.equals(newStack);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return this.enoughFuel(stack) ? 10.0f : 0.0f;
    }

    public boolean isBarVisible(ItemStack p_150899_) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        if (!((Boolean)DistExecutor.safeRunForDist(() -> Screen::hasShiftDown, () -> Boolean.FALSE::booleanValue)).booleanValue()) {
            int fuel = this.getFuelFromStack(stack);
            return (int)Math.round((double)fuel * 13.0 / 1000000.0);
        }
        long power = ItemInfinity.getPowerFromStack(stack);
        return (int)Math.round((double)power * 13.0 / (double)((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getRight())).getPowerNeeded());
    }

    public int getBarColor(ItemStack p_150901_) {
        return (Boolean)DistExecutor.safeRunForDist(() -> Screen::hasShiftDown, () -> Boolean.FALSE::booleanValue) == false ? 13304063 : 53503;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public int getFuelFromStack(ItemStack stack) {
        int fuelAmount = 0;
        if (stack.hasTag() && stack.getTag().contains("Fluid") && stack.getTag().getCompound("Fluid").contains("Amount")) {
            fuelAmount = stack.getTag().getCompound("Fluid").getInt("Amount");
        }
        return fuelAmount;
    }

    public boolean isSpecial(ItemStack stack) {
        return stack.hasTag() && stack.getTag().contains("Special") && stack.getTag().getBoolean("Special");
    }

    public boolean isSpecialEnabled(ItemStack stack) {
        return this.isSpecial(stack) && stack.getTag().contains("SpecialEnabled") && stack.getTag().getBoolean("SpecialEnabled");
    }

    public void setSpecialEnabled(ItemStack stack, boolean special) {
        if (this.isSpecial(stack)) {
            stack.getTag().putBoolean("SpecialEnabled", special);
        }
    }

    public boolean enoughFuel(ItemStack stack) {
        int i = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.UNBREAKING, (ItemStack)stack);
        return (double)this.getFuelFromStack(stack) >= (double)this.biofuelConsumption * (1.0 / (double)(i + 1)) || (double)ItemInfinity.getPowerFromStack(stack) >= (double)this.powerConsumption * (1.0 / (double)(i + 1));
    }

    public void consumeFuel(ItemStack stack) {
        double i = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.UNBREAKING, (ItemStack)stack);
        if ((double)this.getFuelFromStack(stack) >= (double)this.biofuelConsumption * (1.0 / (i + 1.0))) {
            stack.getTag().getCompound("Fluid").putInt("Amount", (int)Math.max(0.0, (double)stack.getTag().getCompound("Fluid").getInt("Amount") - (double)this.biofuelConsumption * (1.0 / (i + 1.0))));
        } else {
            stack.getTag().putLong("Energy", (long)((double)stack.getTag().getLong("Energy") - (double)this.powerConsumption * (1.0 / (i + 1.0))));
        }
    }

    public void setCanCharge(ItemStack stack, boolean canCharge) {
        stack.getTag().putBoolean("CanCharge", canCharge);
    }

    public void setSelectedDrillTier(ItemStack stack, InfinityTier tier) {
        stack.getTag().putString("Selected", tier.name());
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        long power = ItemInfinity.getPowerFromStack(stack);
        Pair<InfinityTier, InfinityTier> braquet = InfinityTier.getTierBraquet(power);
        InfinityTier current = ItemInfinity.getSelectedTier(stack);
        if (this.usesArea) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.current_area").append(" ").append(this.getFormattedArea(stack, current, current.getRadius(), this.usesDepth)).withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.tier").append(" " + ((InfinityTier)((Object)braquet.getLeft())).getColor() + ((InfinityTier)((Object)braquet.getLeft())).getLocalizedName()).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.power").append(" ").append(ChatFormatting.RED + NumberFormat.getNumberInstance(Locale.ROOT).format(power) + ChatFormatting.GREEN).append("/").append(NumberFormat.getNumberInstance(Locale.ROOT).format(((InfinityTier)((Object)braquet.getRight())).getPowerNeeded())).append("RF ").append((Component)Component.translatable((String)"text.industrialforegoing.display.next_tier")).withStyle(ChatFormatting.GRAY));
        int fuelAmount = this.getFuelFromStack(stack);
        tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.fluid").append(" ").append(ChatFormatting.LIGHT_PURPLE + NumberFormat.getNumberInstance(Locale.ROOT).format(fuelAmount) + ChatFormatting.GRAY).append("/").append(NumberFormat.getNumberInstance(Locale.ROOT).format(1000000L)).append(" mb of Biofuel").withStyle(ChatFormatting.GRAY));
        if (this.usesArea) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.max_area").append(" ").append(this.getFormattedArea(stack, (InfinityTier)((Object)braquet.getLeft()), ((InfinityTier)((Object)braquet.getLeft())).getRadius(), this.usesDepth)).withStyle(ChatFormatting.GRAY));
        }
        if (ItemInfinity.canCharge(stack)) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.charging").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"text.industrialforegoing.display.enabled").withStyle(ChatFormatting.GREEN)));
        } else {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.charging").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"text.industrialforegoing.display.disabled").withStyle(ChatFormatting.RED)));
        }
        if (this.isSpecial(stack)) {
            tooltip.add((Component)Component.translatable((String)"text.industrialforegoing.display.special").withStyle(ChatFormatting.GOLD));
        }
    }

    public Pair<BlockPos, BlockPos> getArea(BlockPos pos, Direction facing, InfinityTier currentTier, boolean withDepth) {
        int radius = currentTier.getRadius();
        BlockPos bottomLeft = pos.relative(facing.getAxis() == Direction.Axis.Y ? Direction.SOUTH : Direction.DOWN, radius).relative(facing.getAxis() == Direction.Axis.Y ? Direction.WEST : facing.getCounterClockWise(), radius);
        BlockPos topRight = pos.relative(facing.getAxis() == Direction.Axis.Y ? Direction.NORTH : Direction.UP, radius).relative(facing.getAxis() == Direction.Axis.Y ? Direction.EAST : facing.getClockWise(), radius);
        if (facing.getAxis() != Direction.Axis.Y && radius > 0) {
            bottomLeft = bottomLeft.relative(Direction.UP, radius - 1);
            topRight = topRight.relative(Direction.UP, radius - 1);
        }
        if (currentTier == InfinityTier.ARTIFACT && withDepth) {
            topRight = topRight.relative(facing.getOpposite(), radius);
        }
        return Pair.of((Object)bottomLeft, (Object)topRight);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ListMultimap multimap = MultimapBuilder.hashKeys().arrayListValues().build();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Tool modifier", 3.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool modifier", -2.5, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId()).withStyle(ChatFormatting.DARK_GRAY);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory p_createMenu_2_, Player playerEntity) {
        return new BasicAddonContainer((Object)ItemStackHarnessRegistry.createItemStackHarness((ItemStack)playerEntity.getMainHandItem()), (LocatorInstance)new HeldStackLocatorInstance(true), new ContainerLevelAccess(){

            public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> p_221484_1_) {
                return Optional.empty();
            }
        }, playerEntity.inventory, menu);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        if (player.isCrouching()) {
            if (player instanceof ServerPlayer) {
                IndustrialForegoing.NETWORK.get().sendTo((Object)new BackpackOpenedMessage(player.inventory.selected, PlayerInventoryFinder.MAIN), ((ServerPlayer)player).connection.connection, NetworkDirection.PLAY_TO_CLIENT);
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer((FriendlyByteBuf)buffer, (LocatorInstance)new HeldStackLocatorInstance(handIn == InteractionHand.MAIN_HAND)));
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(handIn));
        }
        if (IndustrialForegoing.CAT_EARS.getPlayers().contains(player.getUUID())) {
            player.getItemInHand(handIn).getOrCreateTag().putBoolean("Special", true);
        }
        return super.use(worldIn, player, handIn);
    }

    public boolean shouldOverrideMultiplayerNbt() {
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InfinityCapabilityProvider(stack, this.getTankConstructor(stack), this.getEnergyConstructor(stack));
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        ItemStack stack = playerEntity.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof ItemInfinity)) {
            stack = playerEntity.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (stack.getItem() instanceof ItemInfinity) {
            if (id == 1) {
                InfinityTier prev = ItemInfinity.getSelectedTier(stack).getPrev((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft()));
                this.setSelectedDrillTier(stack, prev);
            }
            if (id == 2) {
                InfinityTier next = ItemInfinity.getSelectedTier(stack).getNext((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft()));
                this.setSelectedDrillTier(stack, next);
            }
            if (id == 3) {
                this.setCanCharge(stack, !ItemInfinity.canCharge(stack));
            }
            if (id == -10) {
                this.setSpecialEnabled(stack, !this.isSpecialEnabled(stack));
            }
        }
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        ArrayList<IFactory<? extends IScreenAddon>> factory = new ArrayList<IFactory<? extends IScreenAddon>>();
        factory.add(() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 20, 14, 14, FacingUtil.Sideness.RIGHT).setId(2)));
        factory.add(() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 20, 14, 14, FacingUtil.Sideness.LEFT).setId(1)));
        factory.add(() -> new TextScreenAddon("", 72, 24, false){

            public String getText() {
                InfinityTier current = ItemInfinity.getSelectedTier((ItemStack)stack.get());
                return ChatFormatting.DARK_GRAY + "Area: " + ItemInfinity.this.getFormattedArea((ItemStack)stack.get(), current, current.getRadius(), ItemInfinity.this.usesDepth);
            }
        });
        factory.add(() -> new StateButtonAddon(new ButtonComponent(54, 36, 14, 14).setId(3), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

            public int getState() {
                return ItemInfinity.canCharge((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        factory.add(() -> new TextScreenAddon("", 72, 40, false){

            public String getText() {
                if (ItemInfinity.canCharge((ItemStack)stack.get())) {
                    return ChatFormatting.DARK_GRAY + Component.translatable((String)"text.industrialforegoing.display.charging").getString() + ChatFormatting.GREEN + Component.translatable((String)"text.industrialforegoing.display.enabled").getString();
                }
                return ChatFormatting.DARK_GRAY + Component.translatable((String)"text.industrialforegoing.display.charging").getString() + ChatFormatting.RED + Component.translatable((String)"text.industrialforegoing.display.disabled").getString();
            }
        });
        if (this.isSpecial(stack.get())) {
            factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new StateButtonAddon(new ButtonComponent(12, 80, 14, 15).setId(-10), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

                public int getState() {
                    return ItemInfinity.this.isSpecialEnabled((ItemStack)stack.get()) ? 0 : 1;
                }
            }));
            factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon(ChatFormatting.GOLD + Component.translatable((String)"text.industrialforegoing.display.special").getString(), 30, 84, false)));
        }
        return factory;
    }

    public IFactory<? extends FluidHandlerScreenProviderItemStack> getTankConstructor(ItemStack stack) {
        return () -> new FluidHandlerScreenProviderItemStack(stack, 1000000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && fluid.getFluid() != null && fluid.getFluid().equals(ModuleCore.BIOFUEL.getSourceFluid().get());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return false;
            }

            @Nonnull
            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new TankScreenAddon(30, 20, (IFluidTank)this, FluidTankComponent.Type.NORMAL));
            }
        };
    }

    public IFactory<InfinityEnergyStorage> getEnergyConstructor(final ItemStack stack) {
        return () -> new InfinityEnergyStorage(InfinityTier.ARTIFACT.getPowerNeeded(), 10, 20){

            @Override
            public long getLongEnergyStored() {
                if (stack.hasTag()) {
                    return Math.min(stack.getTag().getLong("Energy"), InfinityTier.ARTIFACT.getPowerNeeded());
                }
                return 0L;
            }

            @Override
            public void setEnergyStored(long energy) {
                if (!stack.hasTag()) {
                    stack.setTag(new CompoundTag());
                }
                stack.getTag().putLong("Energy", Math.min(energy, InfinityTier.ARTIFACT.getPowerNeeded()));
            }

            @Override
            public boolean canReceive() {
                return ItemInfinity.canCharge(stack);
            }
        };
    }
}

