/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.addon;

import com.buuz135.industrial.item.addon.AddonItem;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class EfficiencyAddonItem
extends AddonItem
implements ISpecialCreativeTabItem {
    private int tier;

    public EfficiencyAddonItem(int tier, TitaniumTab group) {
        super("efficiency_addon_" + tier, group, new Item.Properties().stacksTo(16));
        this.tier = tier;
    }

    public void onCraftedBy(ItemStack stack, Level worldIn, Player playerIn) {
        super.onCraftedBy(stack, worldIn, playerIn);
        AugmentWrapper.setType((ItemStack)stack, (IAugmentType)AugmentTypes.EFFICIENCY, (float)(1.0f - (float)this.tier * 0.1f));
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TagKey<Item> tierMaterial = this.tier == 1 ? IndustrialTags.Items.GEAR_GOLD : IndustrialTags.Items.GEAR_DIAMOND;
        new DissolutionChamberRecipe(ForgeRegistries.ITEMS.getKey((Object)this), new Ingredient.Value[]{new Ingredient.ItemValue(new ItemStack((ItemLike)Items.REDSTONE)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.REDSTONE)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.GLASS_PANE)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.GLASS_PANE)), new Ingredient.TagValue(tierMaterial), new Ingredient.TagValue(tierMaterial), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.BLAZE_ROD)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.BLAZE_ROD))}, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 1000), 200, new ItemStack((ItemLike)this), FluidStack.EMPTY);
    }

    public String getDescriptionId() {
        return Component.translatable((String)"item.industrialforegoing.addon").getString() + Component.translatable((String)"item.industrialforegoing.efficiency").getString() + "Tier " + this.tier + " ";
    }

    public void addToTab(BuildCreativeModeTabContentsEvent event) {
        ItemStack stack = new ItemStack((ItemLike)this);
        AugmentWrapper.setType((ItemStack)stack, (IAugmentType)AugmentTypes.EFFICIENCY, (float)(1.0f - (float)this.tier * 0.1f));
        event.accept(stack);
    }
}

