/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class MobImprisonmentToolItem
extends IFCustomItem {
    public MobImprisonmentToolItem(TitaniumTab group) {
        super("mob_imprisonment_tool", group, new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack;
        Level worldIn;
        Direction facing;
        BlockPos pos;
        Player player = context.getPlayer();
        if (!this.release(player, pos = context.getClickedPos(), facing = context.getClickedFace(), worldIn = context.getLevel(), stack = context.getItemInHand())) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!this.capture(stack, target)) {
            return InteractionResult.FAIL;
        }
        playerIn.swing(hand);
        playerIn.setItemInHand(hand, stack);
        return InteractionResult.SUCCESS;
    }

    public boolean capture(ItemStack stack, LivingEntity target) {
        if (target.getCommandSenderWorld().isClientSide) {
            return false;
        }
        if (target instanceof Player || !target.canChangeDimensions() || !target.isAlive()) {
            return false;
        }
        if (this.containsEntity(stack)) {
            return false;
        }
        if (this.isBlacklisted(target.getType())) {
            return false;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putString("entity", EntityType.getKey((EntityType)target.getType()).toString());
        target.saveWithoutId(nbt);
        stack.setTag(nbt);
        target.remove(Entity.RemovalReason.KILLED);
        return true;
    }

    public boolean release(Player player, BlockPos pos, Direction facing, Level worldIn, ItemStack stack) {
        if (player.getCommandSenderWorld().isClientSide) {
            return false;
        }
        if (!this.containsEntity(stack)) {
            return false;
        }
        Entity entity = this.getEntityFromStack(stack, worldIn, true, false);
        BlockPos blockPos = pos.relative(facing);
        entity.absMoveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
        stack.setTag(null);
        worldIn.addFreshEntity(entity);
        return true;
    }

    public boolean isBlacklisted(EntityType<?> entity) {
        return TagUtil.hasTag((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, entity, IndustrialTags.EntityTypes.MOB_IMPRISONMENT_TOOL_BLACKLIST);
    }

    public boolean containsEntity(ItemStack stack) {
        return !stack.isEmpty() && stack.hasTag() && stack.getTag().contains("entity");
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (this.containsEntity(stack)) {
            tooltip.add((Component)Component.literal((String)("Mob: " + this.getID(stack))));
            tooltip.add((Component)Component.literal((String)("Health: " + stack.getTag().getDouble("Health"))));
        }
    }

    @Nullable
    public Entity getEntityFromStack(ItemStack stack, Level world, boolean withInfo, boolean applyDuplicatorFilter) {
        EntityType type;
        if (!(!stack.hasTag() || (type = (EntityType)EntityType.byString((String)stack.getTag().getString("entity")).orElse(null)) == null || applyDuplicatorFilter && ForgeRegistries.ENTITY_TYPES.tags().getTag(IndustrialTags.EntityTypes.MOB_DUPLICATOR_BLACKLIST).contains((Object)type))) {
            Entity entity = type.create(world);
            if (withInfo) {
                entity.load(stack.getTag());
            } else if (!type.canSummon()) {
                return null;
            }
            return entity;
        }
        return null;
    }

    public String getID(ItemStack stack) {
        return stack.getTag().getString("entity");
    }

    public Component getName(ItemStack stack) {
        if (!this.containsEntity(stack)) {
            return Component.translatable((String)super.getDescriptionId(stack));
        }
        return Component.translatable((String)super.getDescriptionId(stack)).append(" (" + this.getID(stack) + ")");
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern(" P ").pattern("PGP").pattern(" P ").define(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).define(Character.valueOf('G'), (ItemLike)Items.GHAST_TEAR).save(consumer);
    }
}

