/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.api.straw.StrawHandler;
import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.utils.StrawUtils;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemStraw
extends IFCustomItem {
    public ItemStraw(TitaniumTab group) {
        super("straw", group, new Item.Properties().stacksTo(1));
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack heldStack, Level world, LivingEntity entity) {
        Player player;
        BlockHitResult result;
        if (!world.isClientSide && entity instanceof Player && (result = ItemStraw.getPlayerPOVHitResult((Level)world, (Player)(player = (Player)entity), (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)) != null && result.getType() == HitResult.Type.BLOCK) {
            LazyOptional fluidhandlercap;
            BlockHitResult blockRayTraceResult = result;
            BlockPos pos = blockRayTraceResult.getBlockPos();
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            FluidState fluidState = state.getFluidState();
            if (fluidState != Fluids.EMPTY.defaultFluidState() && block instanceof BucketPickup && fluidState.isSource()) {
                StrawUtils.getStrawHandler(fluidState.getType()).ifPresent(handler -> {
                    ItemStack stack = ((BucketPickup)block).pickupBlock((LevelAccessor)world, pos, state);
                    stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                        if (!iFluidHandlerItem.getFluidInTank(0).isEmpty()) {
                            handler.onDrink(world, pos, iFluidHandlerItem.getFluidInTank(0).getFluid(), player, false);
                        }
                    });
                });
                return heldStack;
            }
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile != null && (fluidhandlercap = tile.getCapability(ForgeCapabilities.FLUID_HANDLER)).isPresent()) {
                IFluidHandler handler2 = (IFluidHandler)fluidhandlercap.orElseThrow(RuntimeException::new);
                int tanks = handler2.getTanks();
                for (int i = 0; i < tanks; ++i) {
                    FluidStack out;
                    FluidStack stack = handler2.getFluidInTank(i);
                    if (stack.isEmpty()) continue;
                    Fluid fluidInstance = stack.getFluid();
                    Optional<StrawHandler> strawHandler = StrawUtils.getStrawHandler(fluidInstance);
                    if (fluidInstance == null || !strawHandler.isPresent() || stack.getAmount() < 1000 || (out = handler2.drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || out.getAmount() < 1000) continue;
                    strawHandler.ifPresent(straw -> straw.onDrink(world, pos, out.getFluid(), player, true));
                    handler2.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        return super.finishUsingItem(heldStack, world, entity);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        BlockHitResult result = ItemStraw.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (result != null && result.getType() == HitResult.Type.BLOCK) {
            LazyOptional fluidhandlercap;
            Optional<StrawHandler> handler;
            BlockHitResult blockRayTraceResult = result;
            BlockPos pos = blockRayTraceResult.getBlockPos();
            BlockState state = worldIn.getBlockState(pos);
            Block block = state.getBlock();
            FluidState fluid = state.getFluidState();
            if (fluid != null && (handler = StrawUtils.getStrawHandler(fluid.getType())).isPresent()) {
                playerIn.startUsingItem(handIn);
                return InteractionResultHolder.success((Object)playerIn.getItemInHand(handIn));
            }
            BlockEntity tile = worldIn.getBlockEntity(pos);
            if (tile != null && (fluidhandlercap = tile.getCapability(ForgeCapabilities.FLUID_HANDLER)).isPresent()) {
                IFluidHandler handler2 = (IFluidHandler)fluidhandlercap.orElseThrow(RuntimeException::new);
                int tanks = handler2.getTanks();
                for (int i = 0; i < tanks; ++i) {
                    FluidStack out;
                    FluidStack stack = handler2.getFluidInTank(i);
                    if (stack.isEmpty()) continue;
                    Fluid fluidInstance = stack.getFluid();
                    Optional<StrawHandler> strawHandler = StrawUtils.getStrawHandler(fluidInstance);
                    if (fluidInstance == null || !strawHandler.isPresent() || stack.getAmount() < 1000 || (out = handler2.drain(stack, IFluidHandler.FluidAction.SIMULATE)) == null || out.getAmount() < 1000) continue;
                    playerIn.startUsingItem(handIn);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
                }
            }
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public int getUseDuration(ItemStack p_77626_1_) {
        return 30;
    }

    public UseAnim getUseAnimation(ItemStack p_77661_1_) {
        return UseAnim.DRINK;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        tooltip.add((Component)Component.literal((String)(ChatFormatting.GRAY + "\"The One Who Codes\"")));
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PP ").pattern(" P ").pattern(" P ").define(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).save(consumer);
    }
}

