/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.item.IFCustomItem;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemConveyorUpgrade
extends IFCustomItem {
    private final ConveyorUpgradeFactory factory;

    public ItemConveyorUpgrade(ConveyorUpgradeFactory upgradeFactory, TitaniumTab group) {
        super("conveyor_" + upgradeFactory.getName() + "_upgrade", group);
        this.factory = upgradeFactory;
        this.factory.setUpgradeItem((Item)this);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getPlayer().isCrouching()) {
            Direction side;
            BlockEntity tile = context.getLevel().getBlockEntity(context.getClickedPos());
            if (tile instanceof ConveyorTile && ((ConveyorTile)tile).getConveyorType().isVertical()) {
                return InteractionResult.PASS;
            }
            if (tile instanceof IBlockContainer && !((IBlockContainer)tile).hasUpgrade(side = this.factory.getSideForPlacement(context.getLevel(), context.getClickedPos(), context.getPlayer()))) {
                ((IBlockContainer)tile).addUpgrade(side, this.factory);
                if (!context.getPlayer().isCreative()) {
                    context.getItemInHand().shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public String getDescriptionId(ItemStack stack) {
        if (this.factory == null) {
            return "conveyor.upgrade.error";
        }
        return String.format("conveyor.upgrade.%s.%s", ForgeRegistries.ITEMS.getKey((Object)this.factory.getUpgradeItem()).getNamespace(), ForgeRegistries.ITEMS.getKey((Object)this.factory.getUpgradeItem()).getPath());
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
    }
}

