/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component.custom;

import com.buuz135.industrial.api.conveyor.gui.PositionedGuiComponent;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.hrznstudio.titanium.util.AssetUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class FilterGuiComponent
extends PositionedGuiComponent {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("industrialforegoing", "textures/gui/conveyor.png");

    public FilterGuiComponent(int x, int y, int xSize, int ySize) {
        super(x, y, xSize, ySize);
    }

    @Override
    public boolean handleClick(AbstractContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16)) {
                    if (conveyor instanceof ICanSendNetworkMessage) {
                        ((ICanSendNetworkMessage)conveyor).sendMessage(pos, Minecraft.getInstance().player.containerMenu.getCarried().serializeNBT());
                    }
                    return true;
                }
                ++pos;
            }
        }
        return false;
    }

    @Override
    public void drawGuiBackgroundLayer(GuiGraphics guiGraphics, int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                guiGraphics.blit(BG_TEXTURE, posX, posY, 176, 0, 18, 18);
                if (!this.getFilter().getFilter()[pos].getStack().isEmpty()) {
                    guiGraphics.renderItem(this.getFilter().getFilter()[pos].getStack(), posX + 1, posY + 1);
                }
                ++pos;
            }
        }
    }

    @Override
    public void drawGuiForegroundLayer(GuiGraphics guiGraphics, int guiX, int guiY, double mouseX, double mouseY) {
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (!(mouseX > (double)(posX + 1)) || !(mouseX < (double)(posX + 1 + 16)) || !(mouseY > (double)(posY + 1)) || !(mouseY < (double)(posY + 1 + 16))) continue;
                AssetUtil.drawSelectingOverlay((GuiGraphics)guiGraphics, (int)(posX + 1 - guiX), (int)(posY + 1 - guiY), (int)(posX + 17 - guiX), (int)(posY + 17 - guiY));
                return;
            }
        }
    }

    @Override
    public boolean isInside(double mouseX, double mouseY) {
        return mouseX > (double)this.getXPos() && mouseX < (double)(this.getXPos() + this.getXSize() * 18) && mouseY > (double)this.getYPos() && mouseY < (double)(this.getYPos() + this.getYSize() * 18);
    }

    public abstract IFilter getFilter();

    @Override
    @Nullable
    public List<Component> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16) && !this.getFilter().getFilter()[pos].getStack().isEmpty()) {
                    Screen cfr_ignored_0 = Minecraft.getInstance().screen;
                    return Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)this.getFilter().getFilter()[pos].getStack());
                }
                ++pos;
            }
        }
        return null;
    }
}

