/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BigItemGuiAddon
extends BasicScreenAddon {
    private boolean tooltip = true;

    protected BigItemGuiAddon(int posX, int posY) {
        super(posX, posY);
    }

    public int getXSize() {
        return 18;
    }

    public int getYSize() {
        return 18;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
        guiGraphics.renderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)this.getItemStack(), (int)1), guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 260.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
        String amount = this.getAmountDisplay();
        guiGraphics.drawString(Minecraft.getInstance().font, ChatFormatting.DARK_GRAY + amount, (int)(((float)(guiX + this.getPosX() + 16) - (float)Minecraft.getInstance().font.width(amount) / 2.0f) * 2.0f), (guiY + this.getPosY() + 19) * 2, 0xFFFFFF);
        guiGraphics.pose().popPose();
    }

    public void drawForegroundLayer(GuiGraphics stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    public BigItemGuiAddon withoutTooltip() {
        this.tooltip = false;
        return this;
    }

    public List<Component> getTooltipLines() {
        if (this.tooltip && !this.getItemStack().isEmpty()) {
            Screen cfr_ignored_0 = Minecraft.getInstance().screen;
            List tp = Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)this.getItemStack());
            tp.add(Component.literal((String)(ChatFormatting.GOLD + new DecimalFormat().format(this.getAmount()))));
            return tp;
        }
        return new ArrayList<Component>();
    }

    public abstract ItemStack getItemStack();

    public abstract int getAmount();

    public abstract String getAmountDisplay();
}

