/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.fluid;

import com.buuz135.industrial.fluid.OreFluidInstance;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.fluid.ClientFluidTypeExtensions;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class OreTitaniumFluidType
extends FluidType {
    public static final String NBT_TAG = "Tag";
    public static HashMap<String, TagKey<Item>> TAG_CACHE = new HashMap();

    public OreTitaniumFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public Component getDescription(FluidStack stack) {
        String tag;
        List items;
        Object extra = "";
        if (stack.hasTag() && stack.getTag().contains(NBT_TAG) && (items = TagUtil.getAllEntries((IForgeRegistry)ForgeRegistries.ITEMS, (TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation((tag = stack.getTag().getString(NBT_TAG)).replace("forge:raw_materials/", "forge:dusts/")))).stream().toList()).size() > 0) {
            extra = " (" + Component.translatable((String)((Item)items.get(0)).getDescriptionId()).getString() + ")";
        }
        return Component.literal((String)(super.getDescription(stack).getString() + (String)extra));
    }

    public String getDescriptionId(FluidStack stack) {
        String tag;
        List items;
        Object extra = "";
        if (stack.hasTag() && stack.getTag().contains(NBT_TAG) && (items = TagUtil.getAllEntries((IForgeRegistry)ForgeRegistries.ITEMS, (TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation((tag = stack.getTag().getString(NBT_TAG)).replace("forge:raw_materials/", "forge:dusts/")))).stream().toList()).size() > 0) {
            extra = " (" + Component.translatable((String)((Item)items.get(0)).getDescriptionId()).getString() + ")";
        }
        return Component.translatable((String)super.getDescriptionId(stack)).getString() + (String)extra;
    }

    public ItemStack getBucket(FluidStack stack) {
        ItemStack bucket = super.getBucket(stack);
        if (stack.hasTag() && stack.getTag().contains(NBT_TAG)) {
            String tag = stack.getTag().getString(NBT_TAG);
            bucket.getOrCreateTag().putString(NBT_TAG, tag);
        }
        return bucket;
    }

    public static FluidStack getFluidWithTag(OreFluidInstance fluidInstance, int amount, ResourceLocation itemITag) {
        FluidStack stack = new FluidStack(fluidInstance.getSourceFluid(), amount);
        stack.getOrCreateTag().putString(NBT_TAG, itemITag.toString());
        return stack;
    }

    public static String getFluidTag(FluidStack stack) {
        return stack.getOrCreateTag().getString(NBT_TAG);
    }

    public static boolean isValid(ResourceLocation resourceLocation) {
        TagKey key = TagUtil.getItemTag((ResourceLocation)new ResourceLocation("forge:dusts/" + resourceLocation.toString().replace("forge:raw_materials/", "")));
        return ForgeRegistries.ITEMS.tags().isKnownTagName(key) && !TagUtil.getAllEntries((IForgeRegistry)ForgeRegistries.ITEMS, (TagKey)key).isEmpty();
    }

    public static ItemStack getOutputDust(FluidStack stack) {
        String tag = OreTitaniumFluidType.getFluidTag(stack);
        if (TAG_CACHE.containsKey(tag)) {
            return TagUtil.getItemWithPreference(TAG_CACHE.get(tag));
        }
        TagKey itemTag = TagUtil.getItemTag((ResourceLocation)new ResourceLocation(tag.replace("forge:raw_materials/", "forge:dusts/")));
        TAG_CACHE.put(tag, (TagKey<Item>)itemTag);
        return TagUtil.getItemWithPreference((TagKey)itemTag);
    }

    public static class Client
    extends ClientFluidTypeExtensions {
        public Client(ResourceLocation still, ResourceLocation flow) {
            super(still, flow);
        }

        public int getTintColor(FluidStack stack) {
            String tag;
            List items;
            if (Minecraft.getInstance().level != null && stack.hasTag() && stack.getTag().contains(OreTitaniumFluidType.NBT_TAG) && (items = TagUtil.getAllEntries((IForgeRegistry)ForgeRegistries.ITEMS, (TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation((tag = stack.getTag().getString(OreTitaniumFluidType.NBT_TAG)).replace("forge:raw_materials/", "forge:dusts/")))).stream().toList()).size() > 0) {
                return ItemStackUtils.getColor(new ItemStack((ItemLike)items.get(0)));
            }
            return -1;
        }
    }
}

