/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity;

import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.item.infinity.item.ItemInfinityTrident;
import com.buuz135.industrial.module.ModuleTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class InfinityTridentEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> LOYALTY_LEVEL = SynchedEntityData.defineId(InfinityTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> CHANNELING = SynchedEntityData.defineId(InfinityTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.defineId(InfinityTridentEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static int DAMAGE = 8;
    private ItemStack thrownStack = new ItemStack((ItemLike)ModuleTool.INFINITY_TRIDENT.get());
    private boolean dealtDamage;
    public int returningTicks;

    public InfinityTridentEntity(EntityType<? extends InfinityTridentEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public InfinityTridentEntity(Level worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super((EntityType)ModuleTool.TRIDENT_ENTITY_TYPE.get(), thrower, worldIn);
        this.thrownStack = thrownStackIn.copy();
        this.entityData.set(LOYALTY_LEVEL, (Object)((ItemInfinityTrident)ModuleTool.INFINITY_TRIDENT.get()).getCurrentLoyalty(this.thrownStack));
        this.entityData.set(CHANNELING, (Object)((ItemInfinityTrident)ModuleTool.INFINITY_TRIDENT.get()).getCurrentChanneling(this.thrownStack));
        this.entityData.set(TIER, (Object)ItemInfinity.getSelectedTier(this.thrownStack).getRadius());
    }

    @OnlyIn(value=Dist.CLIENT)
    public InfinityTridentEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModuleTool.TRIDENT_ENTITY_TYPE.get(), x, y, z, worldIn);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(LOYALTY_LEVEL, (Object)0);
        this.entityData.define(CHANNELING, (Object)false);
        this.entityData.define(TIER, (Object)1);
    }

    public void tick() {
        if (this.inGroundTime > 4 || this.getY() < 0.0) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        if ((this.dealtDamage || this.isNoPhysics()) && entity != null) {
            int loyaltyLevel = (Integer)this.entityData.get(LOYALTY_LEVEL);
            if (!this.shouldReturnToThrower()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.onClientRemoval();
            } else if (loyaltyLevel > 0) {
                this.setNoPhysics(true);
                Vec3 vector3d = new Vec3(entity.getX() - this.getX(), entity.getEyeY() - this.getY(), entity.getZ() - this.getZ());
                this.setPosRaw(this.getX(), this.getY() + vector3d.y * 0.015 * (double)loyaltyLevel, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)loyaltyLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vector3d.normalize().scale(d0)));
                if (this.returningTicks == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.tick();
    }

    protected void onHitEntity(EntityHitResult p_213868_1_) {
        Entity target = p_213868_1_.getEntity();
        float damageHit = (float)((double)DAMAGE + Math.pow(2.0, ((Integer)this.entityData.get(TIER)).intValue())) * 0.5f;
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            damageHit += EnchantmentHelper.getDamageBonus((ItemStack)this.thrownStack, (MobType)livingentity.getMobType());
        }
        Entity entity1 = this.getOwner();
        DamageSource damagesource = target.level().damageSources().trident((Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.TRIDENT_HIT;
        if (target.hurt(damagesource, damageHit)) {
            if (target.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)target;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.doPostHurtEffects((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.doPostDamageEffects((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.doPostHurtEffects(livingentity1);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        AABB area = new AABB(target.getX(), target.getY(), target.getZ(), target.getX(), target.getY(), target.getZ()).inflate((double)((Integer)this.entityData.get(TIER)).intValue());
        List mobs = this.getCommandSenderWorld().getEntitiesOfClass(Mob.class, area);
        if (entity1 instanceof Player) {
            mobs.forEach(mobEntity -> {
                float damage = (float)((double)DAMAGE + Math.pow(2.0, ((Integer)this.entityData.get(TIER)).intValue())) * 0.5f;
                if (target instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)target;
                    damage += EnchantmentHelper.getDamageBonus((ItemStack)this.thrownStack, (MobType)livingentity.getMobType());
                }
                mobEntity.hurt(mobEntity.damageSources().playerAttack((Player)entity1), damage);
            });
            this.getCommandSenderWorld().getEntitiesOfClass(ItemEntity.class, area.inflate(1.0)).forEach(itemEntity -> {
                itemEntity.setNoPickUpDelay();
                itemEntity.teleportTo((double)entity1.blockPosition().getX(), (double)(entity1.blockPosition().getY() + 1), (double)entity1.blockPosition().getZ());
            });
            this.getCommandSenderWorld().getEntitiesOfClass(ExperienceOrb.class, area.inflate(1.0)).forEach(entityXPOrb -> entityXPOrb.teleportTo((double)entity1.blockPosition().getX(), (double)entity1.blockPosition().getY(), (double)entity1.blockPosition().getZ()));
        }
        if (this.level() instanceof ServerLevel && ((Boolean)this.entityData.get(CHANNELING)).booleanValue()) {
            BlockPos blockpos = target.blockPosition();
            if (this.level().canSeeSky(blockpos)) {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                lightningboltentity.moveTo(Vec3.atBottomCenterOf((Vec3i)blockpos));
                lightningboltentity.setCause(entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null);
                this.level().addFreshEntity((Entity)lightningboltentity);
                soundevent = SoundEvents.TRIDENT_THUNDER;
                f1 = 5.0f;
                mobs.forEach(mobEntity -> {
                    if (this.level().canSeeSky(mobEntity.blockPosition())) {
                        LightningBolt lightningboltentity1 = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                        lightningboltentity1.moveTo(Vec3.atBottomCenterOf((Vec3i)mobEntity.blockPosition()));
                        lightningboltentity1.setCause(entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null);
                        this.level().addFreshEntity((Entity)lightningboltentity1);
                    }
                });
            }
        }
        this.playSound(soundevent, f1, 1.0f);
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    protected ItemStack getPickupItem() {
        return this.thrownStack.copy();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEnchanted() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double dist) {
        return dist <= 64.0;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void tickDespawn() {
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Trident", 10)) {
            this.thrownStack = ItemStack.of((CompoundTag)compound.getCompound("Trident"));
        }
        this.dealtDamage = compound.getBoolean("DealtDamage");
        this.entityData.set(LOYALTY_LEVEL, (Object)((ItemInfinityTrident)ModuleTool.INFINITY_TRIDENT.get()).getCurrentLoyalty(this.thrownStack));
        this.entityData.set(CHANNELING, (Object)((ItemInfinityTrident)ModuleTool.INFINITY_TRIDENT.get()).getCurrentChanneling(this.thrownStack));
        this.entityData.set(TIER, (Object)ItemInfinity.getSelectedTier(this.thrownStack).getRadius());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("Trident", (Tag)this.thrownStack.save(new CompoundTag()));
        compound.putBoolean("DealtDamage", this.dealtDamage);
    }
}

