/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.TransporterBlock;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.client.model.TransporterModelData;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class TransporterTile
extends ActiveTile<TransporterTile>
implements IBlockContainer<TransporterTypeFactory> {
    private Map<Direction, TransporterType> transporterTypeMap = new HashMap<Direction, TransporterType>();

    public TransporterTile(BlockPos blockPos, BlockState blockState) {
        super((BasicTileBlock)((RegistryObject)ModuleTransportStorage.TRANSPORTER.getLeft()).get(), (BlockEntityType)((RegistryObject)ModuleTransportStorage.TRANSPORTER.getRight()).get(), blockPos, blockState);
    }

    @Nonnull
    public TransporterTile getSelf() {
        return this;
    }

    @Override
    public Level getBlockWorld() {
        return this.level;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.worldPosition;
    }

    @Override
    public void requestSync() {
        this.markForUpdate();
    }

    @Override
    public void requestFluidSync() {
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, TransporterTile blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        this.getTransporterTypeMap().values().forEach(TransporterType::update);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, TransporterTile blockEntity) {
        super.clientTick(level, pos, state, (BlockEntity)blockEntity);
        this.getTransporterTypeMap().values().forEach(TransporterType::updateClient);
    }

    @Override
    public boolean hasUpgrade(Direction facing) {
        return this.transporterTypeMap.containsKey(facing);
    }

    @Override
    public void addUpgrade(Direction facing, TransporterTypeFactory factory) {
        if (!this.hasUpgrade(facing)) {
            this.transporterTypeMap.put(facing, factory.create(this, facing, TransporterTypeFactory.TransporterAction.EXTRACT));
            this.requestSync();
            if (this.level.isClientSide) {
                this.getLevel().getModelDataManager().requestRefresh((BlockEntity)this);
            }
        }
    }

    @Override
    public void removeUpgrade(Direction facing, boolean drop) {
        if (this.hasUpgrade(facing)) {
            if (!this.level.isClientSide && drop) {
                TransporterType upgrade = this.transporterTypeMap.get(facing);
                for (ItemStack stack : upgrade.getDrops()) {
                    ItemEntity item = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack);
                    item.setItem(stack);
                    this.level.addFreshEntity((Entity)item);
                }
            }
            this.transporterTypeMap.get(facing).onUpgradeRemoved();
            this.transporterTypeMap.remove(facing);
            this.requestSync();
            if (this.level.isClientSide) {
                this.getLevel().getModelDataManager().requestRefresh((BlockEntity)this);
            }
        }
        if (this.transporterTypeMap.isEmpty()) {
            this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
        }
    }

    public void openGui(Player player, Direction facing) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, packetBuffer -> {
                packetBuffer.writeBlockPos(this.worldPosition);
                packetBuffer.writeEnum((Enum)facing);
            });
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new ContainerTransporter(menu, this, (Direction)((TransporterBlock)((Object)((RegistryObject)ModuleTransportStorage.TRANSPORTER.getLeft()).get())).getFacingUpgradeHit(this.level.getBlockState(this.worldPosition), this.level, this.worldPosition, entityPlayer).getLeft(), inventoryPlayer);
    }

    @Override
    public List<Integer> getEntityFilter() {
        return Collections.emptyList();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(TransporterModelData.UPGRADE_PROPERTY, (Object)new TransporterModelData(new HashMap<Direction, TransporterType>(this.transporterTypeMap))).build();
    }

    public Map<Direction, TransporterType> getTransporterTypeMap() {
        return this.transporterTypeMap;
    }

    protected void saveAdditional(CompoundTag compoundTag) {
        super.saveAdditional(compoundTag);
        CompoundTag upgrades = new CompoundTag();
        for (Direction facing : Direction.values()) {
            if (!this.hasUpgrade(facing)) continue;
            CompoundTag upgradeTag = new CompoundTag();
            TransporterType upgrade = this.getTransporterTypeMap().get(facing);
            upgradeTag.putString("factory", ForgeRegistries.ITEMS.getKey((Object)upgrade.getFactory().getUpgradeItem()).toString());
            CompoundTag customNBT = upgrade.serializeNBT();
            if (customNBT != null) {
                upgradeTag.put("customNBT", (Tag)customNBT);
            }
            upgrades.put(facing.getSerializedName(), (Tag)upgradeTag);
        }
        compoundTag.put("Transporters", (Tag)upgrades);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.contains("Transporters")) {
            CompoundTag upgradesTag = compound.getCompound("Transporters");
            for (Direction facing : Direction.values()) {
                if (!upgradesTag.contains(facing.getSerializedName())) continue;
                CompoundTag upgradeTag = upgradesTag.getCompound(facing.getSerializedName());
                TransporterTypeFactory factory = null;
                for (TransporterTypeFactory transporterTypeFactory : TransporterTypeFactory.FACTORIES) {
                    if (!ForgeRegistries.ITEMS.getKey((Object)transporterTypeFactory.getUpgradeItem()).equals((Object)new ResourceLocation(upgradeTag.getString("factory")))) continue;
                    factory = transporterTypeFactory;
                    break;
                }
                if (factory == null) continue;
                TransporterType upgrade = this.transporterTypeMap.getOrDefault(facing, factory.create(this, facing, TransporterTypeFactory.TransporterAction.EXTRACT));
                if (upgradeTag.contains("customNBT")) {
                    upgrade.deserializeNBT(upgradeTag.getCompound("customNBT"));
                }
                this.transporterTypeMap.put(facing, upgrade);
            }
        }
    }
}

