/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.client.model.ConveyorModelData;
import com.buuz135.industrial.utils.MovementUtils;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ConveyorTile
extends ActiveTile<ConveyorTile>
implements IBlockContainer<ConveyorUpgradeFactory> {
    private Direction facing;
    private ConveyorBlock.EnumType type;
    private int color;
    private Map<Direction, ConveyorUpgrade> upgradeMap = new HashMap<Direction, ConveyorUpgrade>();
    private List<Integer> filter;
    private boolean sticky;
    private FluidTank tank;
    private boolean needsFluidSync;

    public ConveyorTile(BlockPos blockPos, BlockState blockState) {
        super((BasicTileBlock)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get(), (BlockEntityType)((RegistryObject)ModuleTransportStorage.CONVEYOR.getRight()).get(), blockPos, blockState);
        this.facing = Direction.NORTH;
        this.type = ConveyorBlock.EnumType.FLAT;
        this.color = DyeColor.WHITE.getMapColor().col;
        this.filter = new ArrayList<Integer>();
        this.sticky = false;
        this.tank = new FluidTank(250);
    }

    @Override
    public Level getBlockWorld() {
        return this.getLevel();
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.getBlockPos();
    }

    @Override
    public void requestSync() {
        this.markForUpdate();
    }

    @Override
    public void requestFluidSync() {
        this.needsFluidSync = true;
    }

    @Override
    public boolean hasUpgrade(Direction facing) {
        return this.upgradeMap.containsKey(facing);
    }

    public int getPower() {
        int highestPower = 0;
        for (ConveyorUpgrade upgrade : this.upgradeMap.values()) {
            int power;
            if (upgrade == null || (power = upgrade.getRedstoneOutput()) <= highestPower) continue;
            highestPower = power;
        }
        return highestPower;
    }

    @Override
    public void addUpgrade(Direction facing, ConveyorUpgradeFactory upgrade) {
        if (!this.hasUpgrade(facing)) {
            this.upgradeMap.put(facing, upgrade.create(this, facing));
            this.requestSync();
            if (this.level.isClientSide) {
                this.getLevel().getModelDataManager().requestRefresh((BlockEntity)this);
            }
        }
    }

    @Override
    public void removeUpgrade(Direction facing, boolean drop) {
        if (this.hasUpgrade(facing)) {
            if (!this.level.isClientSide && drop) {
                ConveyorUpgrade upgrade = this.upgradeMap.get(facing);
                for (ItemStack stack : upgrade.getDrops()) {
                    ItemEntity item = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack);
                    item.setItem(stack);
                    this.level.addFreshEntity((Entity)item);
                }
            }
            this.upgradeMap.get(facing).onUpgradeRemoved();
            this.upgradeMap.remove(facing);
            this.requestSync();
            if (this.level.isClientSide) {
                this.getLevel().getModelDataManager().requestRefresh((BlockEntity)this);
            }
        }
    }

    @Override
    public List<Integer> getEntityFilter() {
        return this.filter;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
        this.markForUpdate();
    }

    public ConveyorBlock.EnumType getConveyorType() {
        return this.type;
    }

    public void setType(ConveyorBlock.EnumType type) {
        this.type = type;
        this.markForUpdate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.markForUpdate();
    }

    public void setColor(DyeColor color) {
        this.color = color.getMapColor().col;
        this.markForUpdate();
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
        this.markForUpdate();
    }

    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        compound.putString("Facing", this.facing.getSerializedName());
        compound.putString("Type", this.type.getName());
        compound.putInt("Color", this.color);
        compound.putBoolean("Sticky", this.sticky);
        CompoundTag upgrades = new CompoundTag();
        for (Direction facing : Direction.values()) {
            if (!this.hasUpgrade(facing)) continue;
            CompoundTag upgradeTag = new CompoundTag();
            ConveyorUpgrade upgrade = this.upgradeMap.get(facing);
            upgradeTag.putString("factory", ForgeRegistries.ITEMS.getKey((Object)upgrade.getFactory().getUpgradeItem()).toString());
            CompoundTag customNBT = upgrade.serializeNBT();
            if (customNBT != null) {
                upgradeTag.put("customNBT", (Tag)customNBT);
            }
            upgrades.put(facing.getSerializedName(), (Tag)upgradeTag);
        }
        compound.put("Upgrades", (Tag)upgrades);
        compound.put("Tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.facing = Direction.byName((String)compound.getString("Facing"));
        this.type = ConveyorBlock.EnumType.getFromName(compound.getString("Type"));
        this.color = compound.getInt("Color");
        this.sticky = compound.getBoolean("Sticky");
        if (compound.contains("Upgrades")) {
            CompoundTag upgradesTag = compound.getCompound("Upgrades");
            for (Direction facing : Direction.values()) {
                if (!upgradesTag.contains(facing.getSerializedName())) continue;
                CompoundTag upgradeTag = upgradesTag.getCompound(facing.getSerializedName());
                ConveyorUpgradeFactory factory = null;
                for (ConveyorUpgradeFactory conveyorUpgradeFactory : ConveyorUpgradeFactory.FACTORIES) {
                    if (!ForgeRegistries.ITEMS.getKey((Object)conveyorUpgradeFactory.getUpgradeItem()).equals((Object)new ResourceLocation(upgradeTag.getString("factory")))) continue;
                    factory = conveyorUpgradeFactory;
                    break;
                }
                if (factory == null) continue;
                ConveyorUpgrade upgrade = this.upgradeMap.getOrDefault(facing, factory.create(this, facing));
                if (upgradeTag.contains("customNBT")) {
                    upgrade.deserializeNBT(upgradeTag.getCompound("customNBT"));
                }
                this.upgradeMap.put(facing, upgrade);
            }
        }
        if (compound.contains("Tank")) {
            this.tank = this.tank.readFromNBT(compound.getCompound("Tank"));
        }
    }

    public void markForUpdate() {
        super.markForUpdate();
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)((BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)ConveyorBlock.FACING, (Comparable)this.facing)).setValue(ConveyorBlock.TYPE, (Comparable)((Object)this.type)));
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag);
        this.level.getBlockEntity(this.worldPosition).load(compoundTag);
    }

    public List<AABB> getCollisionBoxes() {
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        Direction facing = this.facing;
        if (this.type.isDown()) {
            facing = facing.getOpposite();
        }
        for (double height = 1.0; height > 0.0; height -= 0.1) {
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                boxes.add(new AABB(0.0, 0.0, facing == Direction.NORTH ? 0.0 : 1.0 - height, 1.0, 1.0 - height, facing == Direction.NORTH ? height : 1.0));
            }
            if (facing != Direction.WEST && facing != Direction.EAST) continue;
            boxes.add(new AABB(facing == Direction.WEST ? 0.0 : 1.0 - height, 0.0, 0.0, facing == Direction.WEST ? height : 1.0, 1.0 - height, 1.0));
        }
        return boxes;
    }

    public void handleEntityMovement(Entity entity) {
        for (ConveyorUpgrade upgrade : this.upgradeMap.values()) {
            if (upgrade == null) continue;
            upgrade.handleEntity(entity);
        }
        if (entity.isAlive()) {
            if (!this.getEntityFilter().contains(entity.getId())) {
                MovementUtils.handleConveyorMovement(entity, this.facing, this.worldPosition, this.type);
            }
            if (entity instanceof ItemEntity && this.sticky) {
                ((ItemEntity)entity).setPickUpDelay(5);
            }
        }
    }

    public Map<Direction, ConveyorUpgrade> getUpgradeMap() {
        return this.upgradeMap;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, ConveyorTile blockEntity) {
        BlockState state1;
        if (!level.isClientSide && this.tank.getFluidAmount() > 0 && level.getGameTime() % 3L == 0L && level.getBlockState(this.worldPosition.relative(this.facing)).getBlock() instanceof ConveyorBlock && level.getBlockEntity(this.worldPosition.relative(this.facing)) instanceof ConveyorTile && !((ConveyorBlock.EnumType)((Object)(state1 = level.getBlockState(this.worldPosition.relative(this.facing))).getValue(ConveyorBlock.TYPE))).isVertical()) {
            int amount = Math.max(this.tank.getFluidAmount() - 1, 1);
            ConveyorTile conveyorTile = (ConveyorTile)level.getBlockEntity(this.worldPosition.relative(this.facing));
            FluidStack drained = this.tank.drain(conveyorTile.getTank().fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            if (!drained.isEmpty() && drained.getAmount() > 0) {
                this.requestFluidSync();
                conveyorTile.requestFluidSync();
            }
        }
        if (!level.isClientSide && level.getGameTime() % 6L == 0L && this.needsFluidSync) {
            this.markForUpdate();
            this.needsFluidSync = false;
        }
        if (this.type.isVertical() && !this.upgradeMap.isEmpty()) {
            new ArrayList<Direction>(this.upgradeMap.keySet()).forEach(facing1 -> this.removeUpgrade((Direction)facing1, true));
        }
        this.upgradeMap.values().forEach(ConveyorUpgrade::update);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, ConveyorTile blockEntity) {
    }

    @Nonnull
    public ConveyorTile getSelf() {
        return this;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new ContainerConveyor(menu, this, ((ConveyorBlock)((Object)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get())).getFacingUpgradeHit(this.level.getBlockState(this.worldPosition), this.level, this.worldPosition, entityPlayer), inventoryPlayer);
    }

    public void openGui(Player player, Direction facing) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, packetBuffer -> {
                packetBuffer.writeBlockPos(this.worldPosition);
                packetBuffer.writeEnum((Enum)facing);
            });
        }
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ConveyorModelData.UPGRADE_PROPERTY, (Object)new ConveyorModelData(new HashMap<Direction, ConveyorUpgrade>(this.upgradeMap))).build();
    }
}

