/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.block.transportstorage.tile.BHTile;
import com.buuz135.industrial.gui.component.BigItemGuiAddon;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.NumberUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.filter.ItemStackFilter;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.LangUtil;
import com.hrznstudio.titanium.util.RayTraceUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlackHoleUnitTile
extends BHTile<BlackHoleUnitTile> {
    private static HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();
    @Save
    private ItemStack blStack = ItemStack.EMPTY;
    @Save
    private int stored = 0;
    @Save
    private ItemStackFilter filter;
    @Save
    private boolean voidItems = true;
    @Save
    private boolean useStackDisplay = false;
    @Save
    private boolean hasNBT = false;
    private BlackHoleHandler handler;
    private final LazyOptional<IItemHandler> lazyStorage;

    public BlackHoleUnitTile(BasicTileBlock<BlackHoleUnitTile> basicTileBlock, BlockEntityType<?> type, Rarity rarity, BlockPos blockPos, BlockState blockState) {
        super(basicTileBlock, type, blockPos, blockState);
        this.handler = new BlackHoleHandler(BlockUtils.getStackAmountByRarity(rarity));
        this.lazyStorage = LazyOptional.of(() -> this.handler);
        this.filter = new ItemStackFilter("filter", 1);
        this.addFilter((IFilter)this.filter);
        FilterSlot slot = new FilterSlot(79, 60, 0, (Object)ItemStack.EMPTY);
        slot.setColor(DyeColor.CYAN);
        this.filter.setFilter(0, slot);
        this.addButton(new ButtonComponent(122, 80, 18, 18){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        guiGraphics.renderItem(new ItemStack((ItemLike)(BlackHoleUnitTile.this.voidItems ? Items.MAGMA_CREAM : Items.SLIME_BALL)), guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                    }

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> lines = new ArrayList<Component>();
                        lines.add((Component)Component.literal((String)(ChatFormatting.GOLD + LangUtil.getString((String)("tooltip.industrialforegoing.bl." + (BlackHoleUnitTile.this.voidItems ? "void_unit" : "no_void_unit")), (Object[])new Object[0]))));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.voidItems = !this.voidItems;
            this.syncObject(this.voidItems);
        }));
        this.addButton(new ButtonComponent(102, 80, 18, 18){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        guiGraphics.renderItem(new ItemStack((ItemLike)(BlackHoleUnitTile.this.useStackDisplay ? Items.IRON_BLOCK : Items.IRON_INGOT)), guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                    }

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> lines = new ArrayList<Component>();
                        lines.add((Component)Component.literal((String)(ChatFormatting.GOLD + LangUtil.getString((String)("tooltip.industrialforegoing.bl." + (BlackHoleUnitTile.this.useStackDisplay ? "stack_unit" : "compact_unit")), (Object[])new Object[0]))));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.useStackDisplay = !this.useStackDisplay;
            this.syncObject(this.useStackDisplay);
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new BigItemGuiAddon(79, 25){

            @Override
            public ItemStack getItemStack() {
                return BlackHoleUnitTile.this.blStack;
            }

            @Override
            public int getAmount() {
                return BlackHoleUnitTile.this.stored;
            }

            @Override
            public String getAmountDisplay() {
                return BlackHoleUnitTile.this.getFormatedDisplayAmount();
            }
        });
    }

    @Nonnull
    public BlackHoleUnitTile getSelf() {
        return this;
    }

    public InteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (playerIn.isShiftKeyDown()) {
            this.openGui(playerIn);
        } else if (facing.equals((Object)this.getFacingDirection())) {
            ItemStack stack = playerIn.getItemInHand(hand);
            if (!stack.isEmpty() && this.handler.isItemValid(0, stack)) {
                playerIn.setItemInHand(hand, this.handler.insertItem(0, stack, false));
            } else if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.getUUID(), System.currentTimeMillis()) < 300L) {
                for (ItemStack itemStack : playerIn.inventory.items) {
                    if (itemStack.isEmpty() || !this.handler.insertItem(0, itemStack, true).isEmpty()) continue;
                    this.handler.insertItem(0, itemStack.copy(), false);
                    itemStack.setCount(0);
                }
            }
            INTERACTION_LOGGER.put(playerIn.getUUID(), System.currentTimeMillis());
        }
        return InteractionResult.SUCCESS;
    }

    public void onClicked(Player playerIn) {
        BlockHitResult blockResult;
        Direction facing;
        HitResult rayTraceResult;
        if (this.isServer() && (rayTraceResult = RayTraceUtils.rayTraceSimple((Level)this.level, (LivingEntity)playerIn, (double)16.0, (float)0.0f)).getType() == HitResult.Type.BLOCK && (facing = (blockResult = (BlockHitResult)rayTraceResult).getDirection()).equals((Object)this.getFacingDirection())) {
            ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)this.handler.extractItem(0, playerIn.isShiftKeyDown() ? 64 : 1, false));
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, BlackHoleUnitTile blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (this.isServer() && !this.hasNBT && this.blStack.hasTag()) {
            ItemStack stack = this.blStack.copy();
            stack.setTag(null);
            this.setStack(stack);
        }
    }

    public void setAmount(int amount) {
        boolean equal = amount == this.stored;
        this.stored = amount;
        if (!equal) {
            this.syncObject(this.stored);
        }
    }

    public void setStack(ItemStack stack) {
        boolean equal = ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)this.blStack);
        if (!stack.isEmpty()) {
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        }
        this.blStack = stack;
        this.hasNBT = this.blStack.hasTag();
        if (!equal) {
            this.syncObject(this.blStack);
        }
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.blStack;
    }

    @Override
    public String getFormatedDisplayAmount() {
        if (this.useStackDisplay) {
            return this.stored == 0 ? "0" : (String)(this.stored >= 64 ? NumberUtils.getFormatedBigNumber(this.stored / 64) + " x64" : "") + (this.stored >= 64 && this.stored % 64 != 0 ? " + " : "") + (Serializable)(this.stored % 64 != 0 ? Integer.valueOf(this.stored % 64) : "");
        }
        return NumberUtils.getFormatedBigNumber(this.stored);
    }

    public boolean isVoidItems() {
        return this.voidItems;
    }

    private class BlackHoleHandler
    implements IItemHandler {
        private int amount;

        public BlackHoleHandler(int amount) {
            this.amount = amount;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            ItemStack copied = BlackHoleUnitTile.this.blStack.copy();
            copied.setCount(BlackHoleUnitTile.this.stored);
            return copied;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                int inserted = Math.min(this.amount - BlackHoleUnitTile.this.stored, stack.getCount());
                if (!simulate) {
                    BlackHoleUnitTile.this.setStack(stack);
                    BlackHoleUnitTile.this.setAmount(Math.min(BlackHoleUnitTile.this.stored + inserted, this.amount));
                }
                if (inserted == stack.getCount() || BlackHoleUnitTile.this.voidItems) {
                    return ItemStack.EMPTY;
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.getCount() - inserted));
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.EMPTY;
            }
            if (BlackHoleUnitTile.this.blStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (BlackHoleUnitTile.this.stored <= amount) {
                ItemStack out = BlackHoleUnitTile.this.blStack.copy();
                int newAmount = BlackHoleUnitTile.this.stored;
                if (!simulate) {
                    BlackHoleUnitTile.this.setStack(ItemStack.EMPTY);
                    BlackHoleUnitTile.this.setAmount(0);
                }
                out.setCount(newAmount);
                return out;
            }
            if (!simulate) {
                BlackHoleUnitTile.this.setAmount(BlackHoleUnitTile.this.stored - amount);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)BlackHoleUnitTile.this.blStack, (int)amount);
        }

        public int getSlotLimit(int slot) {
            return this.amount;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                ItemStack fl = BlackHoleUnitTile.this.blStack;
                if (!((ItemStack)BlackHoleUnitTile.this.filter.getFilterSlots()[slot].getFilter()).isEmpty() && fl.isEmpty()) {
                    fl = (ItemStack)BlackHoleUnitTile.this.filter.getFilterSlots()[slot].getFilter();
                }
                return fl.isEmpty() || ItemStack.isSameItemSameTags((ItemStack)fl, (ItemStack)stack);
            }
            return false;
        }
    }
}

