/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TextGuiComponent;
import com.buuz135.industrial.gui.component.custom.TextureGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.google.common.collect.ImmutableSet;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class ConveyorBouncingUpgrade
extends ConveyorUpgrade {
    public static VoxelShape BB = Shapes.box((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.075, (double)0.8125);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 3, 3);
    private boolean whitelist = false;
    private double velocityVertical = 1.0;
    private double velocityHorizontal = 1.0;

    public ConveyorBouncingUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        super.handleEntity(entity);
        if (this.whitelist != this.filter.matches(entity)) {
            return;
        }
        Direction direction = (Direction)this.getContainer().getBlockWorld().getBlockState(this.getContainer().getBlockPosition()).getValue((Property)ConveyorBlock.FACING);
        Vec3 vec3d = new Vec3(this.velocityHorizontal * (double)direction.getNormal().getX(), this.velocityVertical, this.velocityHorizontal * (double)direction.getNormal().getZ());
        double x = vec3d.x;
        double y = vec3d.y;
        double z = vec3d.z;
        if (vec3d.y != 0.0) {
            entity.fallDistance = 3.0f;
            y = vec3d.y;
        }
        z = vec3d.z;
        entity.setDeltaMovement(x, y, z);
        this.getWorld().playSound(null, this.getPos(), SoundEvents.PARROT_FLY, SoundSource.AMBIENT, 0.5f, 1.0f);
    }

    @Override
    public VoxelShape getBoundingBox() {
        return BB;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT() == null ? new CompoundTag() : super.serializeNBT();
        compound.put("Filter", (Tag)this.filter.serializeNBT());
        compound.putBoolean("Whitelist", this.whitelist);
        compound.putDouble("VelocityVertical", this.velocityVertical);
        compound.putDouble("VelocityHorizontal", this.velocityHorizontal);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (nbt.contains("Filter")) {
            this.filter.deserializeNBT(nbt.getCompound("Filter"));
        }
        this.whitelist = nbt.getBoolean("Whitelist");
        this.velocityHorizontal = nbt.getDouble("VelocityHorizontal");
        this.velocityVertical = nbt.getDouble("VelocityVertical");
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean ignoresCollision() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.of((CompoundTag)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 10) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 11 && this.velocityHorizontal < 1.0) {
            this.velocityHorizontal += 0.05;
            this.getContainer().requestSync();
        }
        if (buttonId == 12 && this.velocityHorizontal > 0.0) {
            this.velocityHorizontal -= 0.05;
            this.getContainer().requestSync();
        }
        if (buttonId == 13 && this.velocityVertical < 1.0) {
            this.velocityVertical += 0.05;
            this.getContainer().requestSync();
        }
        if (buttonId == 14 && this.velocityVertical > 0.0) {
            this.velocityVertical -= 0.05;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorBouncingUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(10, 80, 19, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorBouncingUpgrade.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TextureGuiComponent(80, 40, 16, 16, res, 2, 234, "bouncing_horizontal"));
        componentList.add(new TextureGuiComponent(80, 56, 16, 16, res, 21, 234, "bouncing_vertical"));
        componentList.add(new TextGuiComponent(104, 44){

            @Override
            public String getText() {
                return ChatFormatting.DARK_GRAY + NumberFormat.getNumberInstance(Locale.ROOT).format(ConveyorBouncingUpgrade.this.velocityHorizontal > 0.0 ? ConveyorBouncingUpgrade.this.velocityHorizontal : 0.0);
            }
        });
        componentList.add(new TextGuiComponent(104, 61){

            @Override
            public String getText() {
                return ChatFormatting.DARK_GRAY + NumberFormat.getNumberInstance(Locale.ROOT).format(ConveyorBouncingUpgrade.this.velocityVertical > 0.0 ? ConveyorBouncingUpgrade.this.velocityVertical : 0.0);
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(11, 130, 40, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(12, 146, 40, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(13, 130, 56, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(14, 146, 56, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            super("bouncing");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorBouncingUpgrade(container, this, face);
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return ImmutableSet.of((Object)new ResourceLocation("industrialforegoing", "block/conveyor_bouncing_upgrade_north"), (Object)new ResourceLocation("industrialforegoing", "block/conveyor_bouncing_upgrade_east"), (Object)new ResourceLocation("industrialforegoing", "block/conveyor_bouncing_upgrade_west"), (Object)new ResourceLocation("industrialforegoing", "block/conveyor_bouncing_upgrade_south"));
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_bouncing_" + conveyorFacing.getSerializedName().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_bouncing_upgrade");
        }

        @Override
        @Nonnull
        public Set<Direction> getValidFacings() {
            return DOWN;
        }

        @Override
        public Direction getSideForPlacement(Level world, BlockPos pos, Player player) {
            return Direction.DOWN;
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).pattern("IPI").pattern("IDI").pattern("ICI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ItemLike)Blocks.SLIME_BLOCK).define(Character.valueOf('D'), (ItemLike)Blocks.PISTON).define(Character.valueOf('C'), (ItemLike)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get()).save(consumer);
        }
    }
}

