/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IRecipeProvider;
import com.hrznstudio.titanium.api.raytrace.DistanceRayTraceResult;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class ConveyorBlock
extends BasicTileBlock<ConveyorTile>
implements SimpleWaterloggedBlock,
IRecipeProvider {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<EnumType> TYPE = EnumProperty.create((String)"type", EnumType.class);
    private ConveyorItem item;

    public ConveyorBlock(TitaniumTab group) {
        super("conveyor", BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.IRON_BLOCK).noCollission().strength(2.0f), ConveyorTile.class);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.setItemGroup(group);
    }

    public int getSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof ConveyorTile) {
            return ((ConveyorTile)tileEntity).getPower();
        }
        return super.getSignal(blockState, world, pos, side);
    }

    public int getDirectSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof ConveyorTile) {
            return side == Direction.UP ? ((ConveyorTile)tileEntity).getPower() : 0;
        }
        return super.getDirectSignal(blockState, world, pos, side);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof ConveyorTile) {
            ConveyorUpgrade upgrade;
            if (target instanceof DistanceRayTraceResult && (upgrade = ((ConveyorTile)tileEntity).getUpgradeMap().get(this.getFacingUpgradeHit(state, player.getCommandSenderWorld(), pos, player))) != null) {
                return new ItemStack((ItemLike)upgrade.getFactory().getUpgradeItem(), 1);
            }
            return new ItemStack((ItemLike)this, 1);
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public BlockState getStateAtViewpoint(BlockState state, BlockGetter world, BlockPos pos, Vec3 viewpoint) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof ConveyorTile) {
            state = (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((ConveyorTile)tileEntity).getFacing())).setValue(TYPE, (Comparable)((Object)((ConveyorTile)tileEntity).getConveyorType()));
        }
        if (((EnumType)((Object)state.getValue(TYPE))).equals((Object)EnumType.FLAT) || ((EnumType)((Object)state.getValue(TYPE))).equals((Object)EnumType.FLAT_FAST)) {
            Direction right = ((Direction)state.getValue((Property)FACING)).getClockWise();
            Direction left = ((Direction)state.getValue((Property)FACING)).getCounterClockWise();
            if (this.isConveyorAndFacing(pos.relative(right), world, left) && this.isConveyorAndFacing(pos.relative(left), world, right) || this.isConveyorAndFacing(pos.relative(right).below(), world, left) && this.isConveyorAndFacing(pos.relative(left).below(), world, right) || this.isConveyorAndFacing(pos.relative(right), world, left) || this.isConveyorAndFacing(pos.relative(right).below(), world, left) || this.isConveyorAndFacing(pos.relative(left), world, right) || this.isConveyorAndFacing(pos.relative(left).below(), world, right)) {
                // empty if block
            }
        }
        return state;
    }

    private boolean isConveyorAndFacing(BlockPos pos, BlockGetter world, Direction toFace) {
        return world.getBlockState(pos).getBlock() instanceof ConveyorBlock && (toFace == null || ((Direction)world.getBlockState(pos).getValue((Property)FACING)).equals((Object)toFace));
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, p_220069_6_);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return ConveyorBlock.getShapes(state, source, pos, conveyorUpgrade -> true);
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos, Predicate<ConveyorUpgrade> filter) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        if (((EnumType)((Object)state.getValue(TYPE))).isVertical()) {
            boxes.add(Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0));
        } else {
            boxes.add(Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0));
        }
        BlockEntity entity = source.getBlockEntity(pos);
        if (entity instanceof ConveyorTile) {
            for (ConveyorUpgrade upgrade : ((ConveyorTile)entity).getUpgradeMap().values()) {
                if (upgrade == null || !filter.test(upgrade)) continue;
                boxes.add(Shapes.create((AABB)upgrade.getBoundingBox().bounds()));
            }
        }
        return boxes;
    }

    @Nonnull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        VoxelShape shape = Shapes.empty();
        for (VoxelShape shape1 : ConveyorBlock.getShapes(state, world, pos, conveyorUpgrade -> !conveyorUpgrade.ignoresCollision())) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)shape1, (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    public boolean hasCustomBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockEntityType.BlockEntitySupplier<ConveyorTile> getTileEntityFactory() {
        return ConveyorTile::new;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (placer != null) {
            BlockEntity tileEntity = worldIn.getBlockEntity(pos);
            if (tileEntity instanceof ConveyorTile) {
                ((ConveyorTile)tileEntity).setFacing(placer.getDirection());
            }
            this.updateConveyorPlacing(worldIn, pos, state, true);
        }
    }

    private void updateConveyorPlacing(Level worldIn, BlockPos pos, BlockState state, boolean first) {
        BlockEntity entity = worldIn.getBlockEntity(pos);
        if (entity instanceof ConveyorTile) {
            Direction direction = ((ConveyorTile)entity).getFacing();
            Direction right = ((Direction)state.getValue((Property)FACING)).getClockWise();
            Direction left = ((Direction)state.getValue((Property)FACING)).getCounterClockWise();
            if (((ConveyorTile)entity).getUpgradeMap().isEmpty()) {
                if (this.isConveyorAndFacing(pos.above().relative(direction), (BlockGetter)worldIn, null)) {
                    ((ConveyorTile)entity).setType(((ConveyorTile)entity).getConveyorType().getVertical(Direction.UP));
                } else if (this.isConveyorAndFacing(pos.above().relative(direction.getOpposite()), (BlockGetter)worldIn, null)) {
                    ((ConveyorTile)entity).setType(((ConveyorTile)entity).getConveyorType().getVertical(Direction.DOWN));
                }
            }
            if (!first) {
                return;
            }
            if (this.isConveyorAndFacing(pos.relative(direction.getOpposite()).below(), (BlockGetter)worldIn, direction)) {
                this.updateConveyorPlacing(worldIn, pos.relative(direction.getOpposite()).below(), state, false);
            }
            if (this.isConveyorAndFacing(pos.relative(left).below(), (BlockGetter)worldIn, right)) {
                this.updateConveyorPlacing(worldIn, pos.relative(left).below(), state, false);
            }
            if (this.isConveyorAndFacing(pos.relative(right).below(), (BlockGetter)worldIn, left)) {
                this.updateConveyorPlacing(worldIn, pos.relative(right).below(), state, false);
            }
            if (this.isConveyorAndFacing(pos.relative(direction).below(), (BlockGetter)worldIn, direction)) {
                this.updateConveyorPlacing(worldIn, pos.relative(direction).below(), state, false);
            }
            worldIn.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        ItemStack handStack = player.getItemInHand(hand);
        if (tileEntity instanceof ConveyorTile) {
            Direction facing = this.getFacingUpgradeHit(state, worldIn, pos, player);
            if (player.isCrouching()) {
                if (facing != null) {
                    ((ConveyorTile)tileEntity).removeUpgrade(facing, true);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (facing == null) {
                if (handStack.getItem().equals(Items.GLOWSTONE_DUST) && !((ConveyorTile)tileEntity).getConveyorType().isFast()) {
                    ((ConveyorTile)tileEntity).setType(((ConveyorTile)tileEntity).getConveyorType().getFast());
                    handStack.shrink(1);
                    return InteractionResult.SUCCESS;
                }
                if (handStack.getItem().equals(ModuleCore.PLASTIC) && !((ConveyorTile)tileEntity).isSticky()) {
                    ((ConveyorTile)tileEntity).setSticky(true);
                    handStack.shrink(1);
                    return InteractionResult.SUCCESS;
                }
                if (handStack.getItem() instanceof DyeItem) {
                    ((ConveyorTile)tileEntity).setColor(((DyeItem)handStack.getItem()).getDyeColor());
                    return InteractionResult.SUCCESS;
                }
            } else if (((ConveyorTile)tileEntity).hasUpgrade(facing)) {
                ConveyorUpgrade upgrade = ((ConveyorTile)tileEntity).getUpgradeMap().get(facing);
                if (upgrade.onUpgradeActivated(player, hand)) {
                    return InteractionResult.SUCCESS;
                }
                if (upgrade.hasGui()) {
                    ((ConveyorTile)tileEntity).openGui(player, facing);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return super.use(state, worldIn, pos, player, hand, ray);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext p_220053_4_) {
        if (((EnumType)((Object)state.getValue(TYPE))).isVertical()) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.4, (double)1.0);
        }
        VoxelShape shape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity instanceof ConveyorTile) {
            for (ConveyorUpgrade upgrade : ((ConveyorTile)entity).getUpgradeMap().values()) {
                if (upgrade == null) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)upgrade.getBoundingBox().bounds()));
            }
        }
        return shape;
    }

    public Direction getFacingUpgradeHit(BlockState state, Level worldIn, BlockPos pos, Player player) {
        VoxelShape hit;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        HitResult result = RayTraceUtils.rayTraceSimple((Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockHitResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockHitResult)((BlockHitResult)result), (Level)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null && tileEntity instanceof ConveyorTile) {
            for (Direction direction : ((ConveyorTile)tileEntity).getUpgradeMap().keySet()) {
                if (!Shapes.joinIsNotEmpty((VoxelShape)((ConveyorTile)tileEntity).getUpgradeMap().get(direction).getBoundingBox(), (VoxelShape)hit, (BooleanOp)BooleanOp.AND)) continue;
                return direction;
            }
        }
        return null;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        ConveyorTile tile = new ConveyorTile(p_153215_, p_153216_);
        return tile;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getPlayer().getDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.entityInside(state, worldIn, pos, entityIn);
        BlockEntity entity = worldIn.getBlockEntity(pos);
        if (entity instanceof ConveyorTile) {
            ((ConveyorTile)entity).handleEntityMovement(entityIn);
        }
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NonNullList drops = NonNullList.create();
        Optional entity = TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, ConveyorTile.class);
        entity.ifPresent(tileEntityConveyor -> {
            for (Direction value : Direction.values()) {
                if (!tileEntityConveyor.getUpgradeMap().containsKey(value)) continue;
                ConveyorUpgrade upgrade = tileEntityConveyor.getUpgradeMap().get(value);
                drops.addAll(upgrade.getDrops());
            }
            if (tileEntityConveyor.isSticky()) {
                drops.add((Object)new ItemStack((ItemLike)ModuleCore.PLASTIC.get()));
            }
            if (tileEntityConveyor.getConveyorType().isFast()) {
                drops.add((Object)new ItemStack((ItemLike)Items.GLOWSTONE_DUST));
            }
        });
        return drops;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return true;
    }

    public boolean isPossibleToRespawnInThis(BlockState p_279289_) {
        return true;
    }

    public ConveyorItem getItem() {
        return this.item;
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)6).pattern("ppp").pattern("iri").pattern("ppp").define(Character.valueOf('p'), IndustrialTags.Items.PLASTIC).define(Character.valueOf('i'), Tags.Items.INGOTS_IRON).define(Character.valueOf('r'), (ItemLike)Items.REDSTONE).save(consumer);
    }

    public static enum EnumType implements StringRepresentable
    {
        FLAT(false, "industrialforegoing:block/conveyor"),
        UP(false, "industrialforegoing:block/conveyor_ramp_inverted", "industrialforegoing:block/conveyor_color_inverted"),
        DOWN(false, "industrialforegoing:block/conveyor_ramp"),
        FLAT_FAST(true, "industrialforegoing:block/conveyor", "industrialforegoing:block/conveyor_color_fast"),
        UP_FAST(true, "industrialforegoing:block/conveyor_ramp_inverted", "industrialforegoing:block/conveyor_color_inverted_fast"),
        DOWN_FAST(true, "industrialforegoing:block/conveyor_ramp", "industrialforegoing:block/conveyor_color_fast");

        private boolean fast;
        private String model;
        private String texture;

        private EnumType(boolean fast, String model) {
            this(false, model, "industrialforegoing:block/conveyor_color");
        }

        private EnumType(boolean fast, String model, String texture) {
            this.fast = fast;
            this.model = model;
            this.texture = texture;
        }

        public static EnumType getFromName(String name) {
            for (EnumType type : EnumType.values()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return type;
            }
            return FLAT;
        }

        public boolean isFast() {
            return this.fast;
        }

        public EnumType getFast() {
            switch (this) {
                case FLAT: {
                    return FLAT_FAST;
                }
                case UP: {
                    return UP_FAST;
                }
                case DOWN: {
                    return DOWN_FAST;
                }
            }
            return this;
        }

        public EnumType getVertical(Direction facing) {
            if (this.isFast()) {
                if (facing == Direction.UP) {
                    return UP_FAST;
                }
                if (facing == Direction.DOWN) {
                    return DOWN_FAST;
                }
                return FLAT_FAST;
            }
            if (facing == Direction.UP) {
                return UP;
            }
            if (facing == Direction.DOWN) {
                return DOWN;
            }
            return FLAT_FAST;
        }

        public boolean isVertical() {
            return this.isDown() || this.isUp();
        }

        public boolean isUp() {
            return this.equals((Object)UP) || this.equals((Object)UP_FAST);
        }

        public boolean isDown() {
            return this.equals((Object)DOWN) || this.equals((Object)DOWN_FAST);
        }

        public String getName() {
            return this.getSerializedName();
        }

        public String getModel() {
            return this.model;
        }

        public String getTexture() {
            return this.texture;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public String getSerializedName() {
            return this.toString().toLowerCase();
        }
    }

    private class ConveyorItem
    extends BlockItem {
        private TitaniumTab group;

        public ConveyorItem(Block block, TitaniumTab group) {
            super(block, new Item.Properties());
            this.group = group;
        }

        @Nullable
        public String getCreatorModId(ItemStack itemStack) {
            return Component.translatable((String)("itemGroup.industrialforegoing_" + this.group.getResourceLocation().getPath())).getString();
        }
    }

    public static enum EnumSides implements StringRepresentable
    {
        NONE,
        LEFT,
        RIGHT,
        BOTH;


        public String getName() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return this.toString().toLowerCase();
        }
    }
}

