/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.item.addon.ProcessingAddonItem;
import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.redstone.RedstoneAction;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public abstract class IndustrialWorkingTile<T extends IndustrialWorkingTile<T>>
extends IndustrialMachineTile<T> {
    @Save
    private ProgressBarComponent<T> workingBar;

    public IndustrialWorkingTile(Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> basicTileBlock, final int estimatedPower, BlockPos blockPos, BlockState blockState) {
        super(basicTileBlock, blockPos, blockState);
        this.workingBar = new ProgressBarComponent<T>(30, 20, this.getMaxProgress(), this.getMaxProgress()){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon(30, 20, IndustrialWorkingTile.this.workingBar){

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)Component.literal((String)(ChatFormatting.GOLD + Component.translatable((String)"tooltip.titanium.progressbar.progress").getString() + ChatFormatting.WHITE + new DecimalFormat().format(IndustrialWorkingTile.this.workingBar.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(IndustrialWorkingTile.this.workingBar.getMaxProgress()))));
                        int progress = IndustrialWorkingTile.this.workingBar.getMaxProgress() - IndustrialWorkingTile.this.workingBar.getProgress();
                        if (!IndustrialWorkingTile.this.workingBar.getIncreaseType()) {
                            progress = IndustrialWorkingTile.this.workingBar.getMaxProgress() - progress;
                        }
                        tooltip.add((Component)Component.literal((String)(ChatFormatting.GOLD + "ETA: " + ChatFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * IndustrialWorkingTile.this.workingBar.getTickingTime()) / 20.0 / (double)IndustrialWorkingTile.this.workingBar.getProgressIncrease())) + ChatFormatting.DARK_AQUA + "s")));
                        if (estimatedPower > 0) {
                            tooltip.add((Component)Component.literal((String)(ChatFormatting.GOLD + Component.translatable((String)"tooltip.industrialforegoing.usage").getString() + ChatFormatting.WHITE + estimatedPower + ChatFormatting.DARK_AQUA + " FE")));
                        }
                        return tooltip;
                    }
                });
            }
        }.setComponentHarness((IComponentHarness)((IndustrialWorkingTile)this.getSelf())).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setIncreaseType(false).setOnFinishWork(() -> {
            if (this.isServer()) {
                WorkAction work = this.work();
                this.getEnergyStorage().extractEnergy(work.getEnergyConsumed(), false);
                int operations = (int)(this.hasAugmentInstalled(ProcessingAddonItem.PROCESSING) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(ProcessingAddonItem.PROCESSING).get(0)), (IAugmentType)ProcessingAddonItem.PROCESSING) - 1.0f : 0.0f);
                for (int i = 0; i < operations; ++i) {
                    work = this.work();
                    this.getEnergyStorage().extractEnergy(work.getEnergyConsumed(), false);
                }
                int maxProgress = (int)Math.floor((float)this.getMaxProgress() * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
                this.workingBar.setMaxProgress(maxProgress);
                this.workingBar.setProgress((int)((float)maxProgress * work.getWorkAmount()));
                this.getRedstoneManager().finish();
            }
        }).setOnTickWork(() -> this.workingBar.setProgressIncrease(this.hasAugmentInstalled(AugmentTypes.SPEED) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.SPEED).get(0)), (IAugmentType)AugmentTypes.SPEED) : 1)).setCanReset(tileEntity -> true).setCanIncrease(tileEntity -> ((RedstoneAction)this.getRedstoneManager().getAction()).canRun(tileEntity.getEnvironmentValue(false, null)) && this.getRedstoneManager().shouldWork()).setColor(DyeColor.LIME);
        this.addProgressBar(this.workingBar);
    }

    public InteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        this.openGui(playerIn);
        return InteractionResult.PASS;
    }

    public abstract WorkAction work();

    public boolean hasEnergy(int amount) {
        return this.getEnergyStorage().getEnergyStored() >= amount;
    }

    public int getMaxProgress() {
        return 100;
    }

    @Override
    public IAssetProvider getAssetProvider() {
        return IndustrialAssetProvider.INSTANCE;
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        return super.canAcceptAugment(augment);
    }

    public class WorkAction {
        private final float workAmount;
        private final int energyConsumed;

        public WorkAction(float workAmount, int energyConsumed) {
            this.workAmount = workAmount;
            this.energyConsumed = energyConsumed;
        }

        public float getWorkAmount() {
            return this.workAmount;
        }

        public int getEnergyConsumed() {
            return this.energyConsumed;
        }
    }
}

