/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;

public abstract class IndustrialAreaWorkingTile<T extends IndustrialAreaWorkingTile<T>>
extends IndustrialWorkingTile<T> {
    @Save
    private int pointer = 0;
    @Save
    private boolean showingArea = false;
    private ButtonComponent areaButton = new ButtonComponent(136, 84, 14, 14){

        @OnlyIn(value=Dist.CLIENT)
        public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
            ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>();
            addons.add(() -> new StateButtonAddon(IndustrialAreaWorkingTile.this.areaButton, new StateButtonInfo[]{new StateButtonInfo(0, IndustrialAssetProvider.BUTTON_SHOW_AREA, new String[]{"text.industrialforegoing.button.show_area"}), new StateButtonInfo(1, IndustrialAssetProvider.BUTTON_HIDE_AREA, new String[]{"text.industrialforegoing.button.hide_area"})}){

                public int getState() {
                    return IndustrialAreaWorkingTile.this.showingArea ? 1 : 0;
                }
            });
            return addons;
        }
    }.setPredicate((playerEntity, compoundNBT) -> {
        this.showingArea = !this.showingArea;
        this.markForUpdate();
    });
    private RangeManager.RangeType type;
    private boolean acceptsRangeUpgrades;

    public IndustrialAreaWorkingTile(Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> basicTileBlock, RangeManager.RangeType type, boolean acceptsRangeUpgrades, int estimatedPower, BlockPos blockPos, BlockState blockState) {
        super(basicTileBlock, estimatedPower, blockPos, blockState);
        this.addButton(this.areaButton);
        this.type = type;
        this.acceptsRangeUpgrades = acceptsRangeUpgrades;
    }

    public VoxelShape getWorkingArea() {
        return new RangeManager(this.worldPosition, this.getFacingDirection(), this.type).get(this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)), (IAugmentType)RangeAddonItem.RANGE) + 1 : 0);
    }

    public BlockPos getPointedBlockPos() {
        List<BlockPos> blockPosList = BlockUtils.getBlockPosInAABB(this.getWorkingArea().bounds());
        this.pointer = this.safetyPointerCheck(blockPosList);
        return blockPosList.get(this.pointer);
    }

    private int safetyPointerCheck(List<BlockPos> blockPosList) {
        return this.pointer < blockPosList.size() ? this.pointer : 0;
    }

    public void increasePointer() {
        BlockPos pointed = this.getPointedBlockPos();
        if (this.level instanceof ServerLevel) {
            ((ServerLevel)this.level).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f((float)Math.abs(this.worldPosition.getX() % 255) / 256.0f, (float)Math.abs(this.worldPosition.getY() % 255) / 256.0f, (float)Math.abs(this.worldPosition.getZ() % 255) / 256.0f), 1.0f), (double)pointed.getX() + 0.5, (double)(pointed.getY() + 1), (double)pointed.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        ++this.pointer;
    }

    public boolean isShowingArea() {
        return this.showingArea;
    }

    public boolean isLoaded(BlockPos pos) {
        return this.level.hasChunksAt(pos, pos);
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)RangeAddonItem.RANGE)) {
            return super.canAcceptAugment(augment) && this.acceptsRangeUpgrades;
        }
        return super.canAcceptAugment(augment);
    }

    public AABB getRenderBoundingBox() {
        return this.getWorkingArea().bounds();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        BlockPos pointed = this.getPointedBlockPos();
        if (!(level instanceof ServerLevel) || level.getGameTime() % 5L == 0L) {
            // empty if block
        }
    }
}

