/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.config.machine.resourceproduction.FluidLaserBaseConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.util.FacingUtil;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidLaserBaseTile
extends IndustrialMachineTile<FluidLaserBaseTile>
implements ILaserBase<FluidLaserBaseTile> {
    @Save
    private ProgressBarComponent<FluidLaserBaseTile> work;
    @Save
    private SidedInventoryComponent<FluidLaserBaseTile> catalyst;
    @Save
    private SidedFluidTankComponent<FluidLaserBaseTile> output;
    @Save
    private int miningDepth;

    public FluidLaserBaseTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.FLUID_LASER_BASE, blockPos, blockState);
        this.setShowEnergy(false);
        this.miningDepth = this.getBlockPos().getY();
        this.work = new ProgressBarComponent<FluidLaserBaseTile>(74, 42, 0, FluidLaserBaseConfig.maxProgress){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<FluidLaserBaseTile>(FluidLaserBaseTile.this.work.getPosX(), FluidLaserBaseTile.this.work.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)Component.literal((String)(ChatFormatting.GOLD + Component.translatable((String)"tooltip.titanium.progressbar.progress").getString() + ChatFormatting.WHITE + new DecimalFormat().format(FluidLaserBaseTile.this.work.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(FluidLaserBaseTile.this.work.getMaxProgress()))));
                        return tooltip;
                    }
                });
            }
        }.setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setCanIncrease(oreLaserBaseTile -> true).setProgressIncrease(0).setCanReset(oreLaserBaseTile -> true).setOnStart(() -> {
            int maxProgress = (int)Math.floor((float)FluidLaserBaseConfig.maxProgress * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
            this.work.setMaxProgress(maxProgress);
        }).setOnFinishWork(this::onWork);
        this.addProgressBar(this.work);
        this.catalyst = (SidedInventoryComponent)new SidedInventoryComponent("lens", 50, 42, 1, 0).setColor(DyeColor.BLUE).setRange(2, 3).setSlotLimit(1);
        this.addInventory((InventoryComponent)this.catalyst);
        this.catalyst.getFacingModes().keySet().forEach(sideness -> this.catalyst.getFacingModes().put(sideness, IFacingComponent.FaceMode.NONE));
        this.output = (SidedFluidTankComponent)new SidedFluidTankComponent("output", 32000, 102, 20, 1).setColor(DyeColor.ORANGE).setTankAction(FluidTankComponent.Action.DRAIN);
        this.addTank(this.output);
        int y = 84;
        this.addButton(new ArrowButtonComponent(53, y, 14, 14, FacingUtil.Sideness.LEFT).setPredicate((playerEntity, compoundNBT) -> {
            this.miningDepth = Math.max(-64, this.miningDepth - 1);
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(126, y, 14, 14, FacingUtil.Sideness.RIGHT).setPredicate((playerEntity, compoundNBT) -> {
            this.miningDepth = Math.min(255, this.miningDepth + 1);
            this.markForUpdate();
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new TextScreenAddon("", 70, 87, false){

            public String getText() {
                return ChatFormatting.DARK_GRAY + Component.translatable((String)"text.industrialforegoing.depth").getString() + FluidLaserBaseTile.this.miningDepth;
            }
        });
    }

    public void setChanged() {
        super.setChanged();
        if (this.miningDepth == -100) {
            this.miningDepth = this.worldPosition.getY();
        }
    }

    private void onWork() {
        if (!this.catalyst.getStackInSlot(0).isEmpty()) {
            VoxelShape box = Shapes.box((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).move((double)this.worldPosition.getX(), (double)(this.worldPosition.getY() - 1), (double)this.worldPosition.getZ());
            RecipeUtil.getRecipes((Level)this.level, (RecipeType)((RecipeType)ModuleCore.LASER_DRILL_FLUID_TYPE.get())).stream().filter(laserDrillFluidRecipe -> laserDrillFluidRecipe.catalyst.test(this.catalyst.getStackInSlot(0))).filter(laserDrillFluidRecipe -> laserDrillFluidRecipe.getValidRarity(((ResourceKey)this.level.getBiome(this.worldPosition).unwrapKey().get()).location(), this.miningDepth) != null).findFirst().ifPresent(laserDrillFluidRecipe -> {
                if (!LaserDrillFluidRecipe.EMPTY.equals((Object)laserDrillFluidRecipe.entity)) {
                    LivingEntity first;
                    List entities = this.level.getEntitiesOfClass(LivingEntity.class, box.bounds(), entity -> ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.getType()).equals((Object)laserDrillFluidRecipe.entity));
                    if (entities.size() > 0 && (first = (LivingEntity)entities.get(0)).getHealth() > 5.0f) {
                        first.hurt(first.damageSources().generic(), 5.0f);
                        this.output.fillForced(FluidStack.loadFluidStackFromNBT((CompoundTag)laserDrillFluidRecipe.output), IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    this.output.fillForced(FluidStack.loadFluidStackFromNBT((CompoundTag)laserDrillFluidRecipe.output), IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
    }

    public FluidLaserBaseTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<FluidLaserBaseTile> createEnergyStorage() {
        return new EnergyStorageComponent(0, 4, 10);
    }

    @Override
    public ProgressBarComponent<FluidLaserBaseTile> getBar() {
        return this.work;
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.SPEED)) {
            return false;
        }
        return super.canAcceptAugment(augment);
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putInt("FL_miningDepth", this.miningDepth);
        super.saveSettings(player, tag);
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("FL_miningDepth")) {
            this.miningDepth = tag.getInt("FL_miningDepth");
        }
        super.loadSettings(player, tag);
    }
}

