/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.misc.EnchantmentExtractorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.LangUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EnchantmentExtractorTile
extends IndustrialProcessingTile<EnchantmentExtractorTile> {
    @Save
    private boolean extractEnchants = true;
    @Save
    private SidedInventoryComponent<EnchantmentExtractorTile> inputEnchantedItem = (SidedInventoryComponent)new SidedInventoryComponent("inputEnchantedItem", 40, 22, 1, 0).setColor(DyeColor.BLUE).setSlotLimit(1).setInputFilter((stack, integer) -> (stack.isEnchanted() || stack.getItem() == Items.ENCHANTED_BOOK) && !stack.is(IndustrialTags.Items.ENCHANTMENT_EXTRACTOR_BLACKLIST)).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
    @Save
    private SidedInventoryComponent<EnchantmentExtractorTile> inputBook;
    @Save
    private SidedInventoryComponent<EnchantmentExtractorTile> outputEnchantedBook;
    @Save
    private SidedInventoryComponent<EnchantmentExtractorTile> outputNoEnchantedItem;
    @Save
    private SidedFluidTankComponent<EnchantmentExtractorTile> tank;
    private ButtonComponent buttonComponent;

    public EnchantmentExtractorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleMisc.ENCHANTMENT_EXTRACTOR, 62, 40, blockPos, blockState);
        this.addInventory((InventoryComponent)this.inputEnchantedItem);
        this.inputBook = (SidedInventoryComponent)new SidedInventoryComponent("inputBook", 40, 58, 1, 1).setColor(DyeColor.BROWN).setInputFilter((stack, integer) -> stack.getItem().equals(Items.BOOK)).setOutputFilter((stack, integer) -> false).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.BOOK)).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputBook);
        this.outputNoEnchantedItem = (SidedInventoryComponent)new SidedInventoryComponent("outputNoEnchantedItem", 90, 22, 3, 2).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.outputNoEnchantedItem);
        this.outputEnchantedBook = (SidedInventoryComponent)new SidedInventoryComponent("outputEnchantedBook", 90, 58, 3, 3).setColor(DyeColor.MAGENTA).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.outputEnchantedBook);
        this.tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", EnchantmentExtractorConfig.tankSize, 150, 20, 4).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().is(IndustrialTags.Fluids.EXPERIENCE));
        this.addTank(this.tank);
        this.buttonComponent = new ButtonComponent(66, 58, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(this, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.enchantment_extractor.extract", (Object[])new Object[0]), "tooltip.industrialforegoing.enchantment_extractor.extract_extra"}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{ChatFormatting.GOLD + LangUtil.getString((String)"tooltip.industrialforegoing.enchantment_extractor.consume", (Object[])new Object[0]), "tooltip.industrialforegoing.enchantment_extractor.consume_extra"})}){

                    public int getState() {
                        return EnchantmentExtractorTile.this.extractEnchants ? 0 : 1;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.extractEnchants = !this.extractEnchants;
            this.markForUpdate();
        });
        this.addButton(this.buttonComponent);
    }

    @Override
    public boolean canIncrease() {
        return !this.inputEnchantedItem.getStackInSlot(0).isEmpty() && !ItemStackUtils.isInventoryFull(this.outputNoEnchantedItem) && (this.extractEnchants ? !this.inputBook.getStackInSlot(0).isEmpty() && !ItemStackUtils.isInventoryFull(this.outputEnchantedBook) : this.tank.getCapacity() >= this.tank.getFluidAmount() + this.getEnchantmentXp(this.inputEnchantedItem.getStackInSlot(0)) * 20);
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ItemStack input = this.inputEnchantedItem.getStackInSlot(0);
            if (this.extractEnchants) {
                Map<Enchantment, Integer> map = EnchantmentHelper.getEnchantments((ItemStack)input).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (map.size() > 0) {
                    Enchantment selected = map.keySet().iterator().next();
                    ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                    EnchantmentHelper.setEnchantments(Collections.singletonMap(selected, map.get(selected)), (ItemStack)book);
                    if (map.keySet().stream().allMatch(Enchantment::isCurse)) {
                        ItemStack output = input.copy();
                        input.shrink(1);
                        ItemHandlerHelper.insertItem(this.outputNoEnchantedItem, (ItemStack)output, (boolean)false);
                    } else if (map.size() == 1) {
                        ItemStack output = this.removeEnchantments(input, input.getDamageValue(), input.getCount());
                        input.shrink(1);
                        ItemHandlerHelper.insertItem(this.outputNoEnchantedItem, (ItemStack)output, (boolean)false);
                        ItemHandlerHelper.insertItem(this.outputEnchantedBook, (ItemStack)book, (boolean)false);
                        this.inputBook.getStackInSlot(0).shrink(1);
                    } else {
                        Map<Enchantment, Integer> cleanMap = EnchantmentHelper.getEnchantments((ItemStack)input).entrySet().stream().filter(enchantmentPair -> !((Enchantment)enchantmentPair.getKey()).equals(selected)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                        if (input.getItem() == Items.ENCHANTED_BOOK) {
                            input.removeTagKey("Enchantments");
                            input.removeTagKey("StoredEnchantments");
                        }
                        EnchantmentHelper.setEnchantments(cleanMap, (ItemStack)input);
                        ItemHandlerHelper.insertItem(this.outputEnchantedBook, (ItemStack)book, (boolean)false);
                        this.inputBook.getStackInSlot(0).shrink(1);
                    }
                }
            } else {
                int essence = this.getEnchantmentXp(input) * 20;
                ItemStack output = this.removeEnchantments(input, input.getDamageValue(), input.getCount());
                input.shrink(1);
                ItemHandlerHelper.insertItem(this.outputNoEnchantedItem, (ItemStack)output, (boolean)false);
                this.tank.fillForced(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), essence), IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    protected int getTickPower() {
        return EnchantmentExtractorConfig.powerPerTick;
    }

    @Override
    public int getMaxProgress() {
        return EnchantmentExtractorConfig.maxProgress;
    }

    public EnchantmentExtractorTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<EnchantmentExtractorTile> createEnergyStorage() {
        return new EnergyStorageComponent(EnchantmentExtractorConfig.maxStoredPower, 10, 20);
    }

    private int getEnchantmentXp(ItemStack stack) {
        int xp = 0;
        Map map = EnchantmentHelper.getEnchantments((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.isCurse()) continue;
            xp += enchantment.getMinCost(integer.intValue());
        }
        return xp;
    }

    private ItemStack removeEnchantments(ItemStack stack, int damage, int count) {
        ItemStack itemstack = stack.copy();
        itemstack.removeTagKey("Enchantments");
        itemstack.removeTagKey("StoredEnchantments");
        if (damage > 0) {
            itemstack.setDamageValue(damage);
        } else {
            itemstack.removeTagKey("Damage");
        }
        itemstack.setCount(count);
        Map<Enchantment, Integer> map = EnchantmentHelper.getEnchantments((ItemStack)stack).entrySet().stream().filter(enchantmentPair -> ((Enchantment)enchantmentPair.getKey()).isCurse()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.setEnchantments(map, (ItemStack)itemstack);
        itemstack.setRepairCost(0);
        if (itemstack.getItem() == Items.ENCHANTED_BOOK && map.size() == 0) {
            itemstack = new ItemStack((ItemLike)Items.BOOK);
            if (stack.hasCustomHoverName()) {
                itemstack.setHoverName(stack.getHoverName());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            itemstack.setRepairCost(AnvilMenu.calculateIncreasedRepairCost((int)itemstack.getBaseRepairCost()));
        }
        return itemstack;
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("EE_extractEnchants")) {
            this.extractEnchants = tag.getBoolean("EE_extractEnchants");
        }
        super.loadSettings(player, tag);
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putBoolean("EE_extractEnchants", this.extractEnchants);
        super.saveSettings(player, tag);
    }
}

