/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc;

import com.buuz135.industrial.block.IndustrialBlock;
import com.buuz135.industrial.block.misc.tile.MobDetectorTile;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MobDetectorBlock
extends IndustrialBlock<MobDetectorTile> {
    public MobDetectorBlock() {
        super("mob_detector", BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.IRON_BLOCK), MobDetectorTile.class, ModuleMisc.TAB_MISC);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        Direction facing = (Direction)blockState.getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        if (side != facing && world.getBlockEntity(pos) instanceof MobDetectorTile) {
            return ((MobDetectorTile)world.getBlockEntity(pos)).getRedstoneSignal();
        }
        return 0;
    }

    public BlockEntityType.BlockEntitySupplier<MobDetectorTile> getTileEntityFactory() {
        return MobDetectorTile::new;
    }

    @Nonnull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("ppp").pattern("rcr").pattern("omo").define(Character.valueOf('p'), IndustrialTags.Items.PLASTIC).define(Character.valueOf('r'), (ItemLike)Items.REPEATER).define(Character.valueOf('c'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('o'), (ItemLike)Items.OBSERVER).define(Character.valueOf('m'), IndustrialTags.Items.MACHINE_FRAME_SIMPLE).save(consumer);
    }
}

