/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.tile.IndustrialGeneratorTile;
import com.buuz135.industrial.config.machine.generator.BiofuelGeneratorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BiofuelGeneratorTile
extends IndustrialGeneratorTile<BiofuelGeneratorTile> {
    private int getPowerPerTick;
    private int getExtractionRate;
    @Save
    private SidedFluidTankComponent<BiofuelGeneratorTile> biofuel = (SidedFluidTankComponent)new SidedFluidTankComponent("biofuel", BiofuelGeneratorConfig.maxBiofuelTankSize, 43, 20, 0).setColor(DyeColor.PURPLE).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)ModuleCore.BIOFUEL.getSourceFluid().get()));

    public BiofuelGeneratorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleGenerator.BIOFUEL_GENERATOR, blockPos, blockState);
        this.addTank((FluidTankComponent)this.biofuel);
        this.getPowerPerTick = BiofuelGeneratorConfig.powerPerTick;
        this.getExtractionRate = BiofuelGeneratorConfig.extractionRate;
    }

    public int consumeFuel() {
        if (this.biofuel.getFluidAmount() > 0) {
            this.biofuel.drainForced(1, IFluidHandler.FluidAction.EXECUTE);
            return 4;
        }
        return 0;
    }

    public boolean canStart() {
        return this.biofuel.getFluidAmount() > 0 && this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored();
    }

    public int getEnergyProducedEveryTick() {
        return this.getPowerPerTick;
    }

    public ProgressBarComponent getProgressBar() {
        return new ProgressBarComponent(30, 20, 0, BiofuelGeneratorConfig.maxProgress).setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
    }

    public int getEnergyCapacity() {
        return BiofuelGeneratorConfig.maxStoredPower;
    }

    public int getExtractingEnergy() {
        return BiofuelGeneratorConfig.extractionRate;
    }

    @Nonnull
    public BiofuelGeneratorTile getSelf() {
        return this;
    }
}

