/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.generator.BioReactorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.bundle.LockableInventoryBundle;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class BioReactorTile
extends IndustrialWorkingTile<BioReactorTile> {
    public static TagKey<Item>[] VALID = new TagKey[]{IndustrialTags.Items.BIOREACTOR_INPUT, Tags.Items.CROPS, Tags.Items.DYES, Tags.Items.HEADS, Tags.Items.MUSHROOMS, Tags.Items.SEEDS, ItemTags.SAPLINGS};
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<BioReactorTile> biofuel;
    @Save
    private SidedFluidTankComponent<BioReactorTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", BioReactorConfig.maxWaterTankStorage, 45, 20, 0).setColor(DyeColor.CYAN).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().equals(Fluids.WATER));
    @Save
    private LockableInventoryBundle<BioReactorTile> input;
    @Save
    private ProgressBarComponent<BioReactorTile> bar;

    public BioReactorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleGenerator.BIOREACTOR, BioReactorConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.water);
        this.input = new LockableInventoryBundle((BasicTile)this, new SidedInventoryComponent("input", 69, 22, 9, 1).setColor(DyeColor.BLUE).setRange(3, 3).setInputFilter((stack, integer) -> this.canInsert(integer - 2, (ItemStack)stack)).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this), 136, 84, false);
        this.addBundle((IComponentBundle)this.input);
        this.biofuel = (SidedFluidTankComponent)new SidedFluidTankComponent("biofuel", BioReactorConfig.maxBioFuelTankStorage, 128, 20, 2).setColor(DyeColor.PURPLE).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.DRAIN).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)ModuleCore.BIOFUEL.getSourceFluid().get()));
        this.addTank(this.biofuel);
        this.bar = new ProgressBarComponent<BioReactorTile>(150, 20, BioReactorConfig.maxProgress){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<BioReactorTile>(BioReactorTile.this.bar.getPosX(), BioReactorTile.this.bar.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        return Arrays.asList(Component.literal((String)(ChatFormatting.GOLD + "Efficiency: " + ChatFormatting.WHITE + (int)((double)BioReactorTile.this.getEfficiency() / 9.0 * 100.0) + ChatFormatting.DARK_AQUA + "%")));
                    }
                });
            }
        }.setColor(DyeColor.YELLOW).setCanIncrease(tileEntity -> true).setOnTickWork(() -> this.bar.setProgress((int)((double)this.getEfficiency() / 9.0 * 100.0))).setCanReset(tileEntity -> this.getEfficiency() != 9).setComponentHarness((IComponentHarness)this);
        this.addProgressBar(this.bar);
        this.getMaxProgress = BioReactorConfig.maxProgress;
        this.getPowerPerOperation = BioReactorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation)) {
            int efficiency = this.getEfficiency();
            if (efficiency <= 0) {
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
            }
            int fluidAmount = ((efficiency - 1) * 18 + 93) * efficiency + 2;
            if (this.water.getFluidAmount() >= fluidAmount && this.biofuel.getCapacity() - this.biofuel.getFluidAmount() >= fluidAmount) {
                this.water.drainForced(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
                this.biofuel.fillForced(new FluidStack((Fluid)ModuleCore.BIOFUEL.getSourceFluid().get(), fluidAmount), IFluidHandler.FluidAction.EXECUTE);
                for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
                    this.input.getInventory().getStackInSlot(i).shrink(1);
                }
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private boolean canInsert(int slot, ItemStack stack) {
        int foundSlot = -1;
        for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
            if (!ItemStack.isSameItem((ItemStack)this.input.getInventory().getStackInSlot(i), (ItemStack)stack)) continue;
            foundSlot = i;
        }
        for (TagKey<Item> itemTag : VALID) {
            if (!ForgeRegistries.ITEMS.tags().getTag(itemTag).contains((Object)stack.getItem()) || foundSlot != -1 && (this.input.getInventory().getStackInSlot(foundSlot).getCount() + stack.getCount() > this.input.getInventory().getStackInSlot(foundSlot).getMaxStackSize() || slot != foundSlot)) continue;
            return true;
        }
        return false;
    }

    private int getEfficiency() {
        int slots = 0;
        for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
            if (this.input.getInventory().getStackInSlot(i).isEmpty()) continue;
            ++slots;
        }
        return slots;
    }

    protected EnergyStorageComponent<BioReactorTile> createEnergyStorage() {
        return new EnergyStorageComponent(BioReactorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public BioReactorTile getSelf() {
        return this;
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("BR_locked")) {
            this.input.setLocked(tag.getBoolean("BR_locked"));
        }
        if (tag.contains("BR_filter")) {
            for (String psFilter : tag.getCompound("BR_filter").getAllKeys()) {
                this.input.getFilter()[Integer.parseInt((String)psFilter)] = ItemStack.of((CompoundTag)tag.getCompound("BR_filter").getCompound(psFilter));
            }
        }
        super.loadSettings(player, tag);
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putBoolean("BR_locked", this.input.isLocked());
        CompoundTag filterTag = new CompoundTag();
        for (int i = 0; i < this.input.getFilter().length; ++i) {
            filterTag.put("" + i, (Tag)this.input.getFilter()[i].serializeNBT());
        }
        tag.put("BR_filter", (Tag)filterTag);
        super.saveSettings(player, tag);
    }
}

