/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class DisenchantmentGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "disenchantment";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT, IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, integer) -> stack.isEnchanted() || stack.getItem() instanceof EnchantedBookItem, (stack, integer) -> false);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && inputs[1] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0 && this.getSlotInputPredicates().get(0).test(((SidedInventoryComponent)inputs[0]).getStackInSlot(0), 0) && ((SidedInventoryComponent)inputs[1]).getStackInSlot(0).isEmpty();
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0) {
            ItemStack itemstack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).copy();
            ((SidedInventoryComponent)inputs[0]).setStackInSlot(0, ItemStack.EMPTY);
            if (itemstack.getItem().equals(Items.ENCHANTED_BOOK)) {
                ((SidedInventoryComponent)inputs[1]).setStackInSlot(0, new ItemStack((ItemLike)Items.BOOK));
            } else {
                ((SidedInventoryComponent)inputs[1]).setStackInSlot(0, new ItemStack((ItemLike)itemstack.getItem()));
            }
            return this.calculate(itemstack);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.LIME, DyeColor.ORANGE};
    }

    @Override
    public Item getDisplay() {
        return Items.ENCHANTED_BOOK;
    }

    @Override
    public int getSlotSize() {
        return 1;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes() {
        ArrayList<MycelialGeneratorRecipe> recipes = new ArrayList<MycelialGeneratorRecipe>();
        for (Enchantment value : ForgeRegistries.ENCHANTMENTS.getValues()) {
            for (int i = value.getMinLevel(); i <= value.getMaxLevel(); ++i) {
                HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
                map.put(value, i);
                ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                EnchantmentHelper.setEnchantments(map, (ItemStack)book);
                Pair<Integer, Integer> power = this.calculate(book);
                recipes.add(new MycelialGeneratorRecipe(Arrays.asList(Collections.singletonList(Ingredient.of((ItemStack[])new ItemStack[]{book})), Collections.singletonList(Ingredient.of((ItemStack[])new ItemStack[]{ItemStack.EMPTY}))), new ArrayList<List<FluidStack>>(), (Integer)power.getLeft(), (Integer)power.getRight()));
            }
        }
        return recipes;
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        Map ench = EnchantmentHelper.getEnchantments((ItemStack)stack);
        int rarity = 0;
        double level = 0.0;
        for (Map.Entry enchEntry : ench.entrySet()) {
            rarity += 14 - ((Enchantment)enchEntry.getKey()).getRarity().getWeight();
            level += (double)((Integer)enchEntry.getValue()).intValue() / (double)((Enchantment)enchEntry.getKey()).getMaxLevel();
        }
        return Pair.of((Object)(rarity * 80), (Object)((int)(160.0 * level)));
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('C'), (ItemLike)Blocks.GRINDSTONE).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }
}

