/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.compat.jei;

import com.blamejared.wac.WAC;
import com.blamejared.wac.compat.jei.RitualCategory;
import com.blamejared.wac.item.WACItems;
import com.blamejared.wac.recipe.WACRecipes;
import com.blamejared.wac.recipe.ritual.Ritual;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class WACJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = WAC.rl("default");
    public static final RecipeType<Ritual> RITUAL = RecipeType.create((String)"wac", (String)"ritual", Ritual.class);

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper gui = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new RitualCategory(gui)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)WACItems.DEEPSLATE_BASIN.get(), new RecipeType[]{RITUAL});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            List<Ritual> list = level.getRecipeManager().getAllRecipesFor(WACRecipes.RITUAL_TYPE.get()).stream().map(RecipeHolder::value).toList();
            registration.addRecipes(RITUAL, list);
        }
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

