/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.client.render.shader;

import com.blamejared.wac.client.render.shader.ShaderTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;

public class WACRenderTypes
extends RenderType {
    private static final Map<String, ShaderRenderType> RENDER_TYPES = (Map)Util.make(() -> {
        HashMap map = new HashMap();
        return Collections.unmodifiableMap(map);
    });

    public static Map<String, ShaderRenderType> getRenderTypes() {
        return RENDER_TYPES;
    }

    public static ShaderRenderType getRenderType(String name) {
        return WACRenderTypes.getRenderTypes().get(name);
    }

    private WACRenderTypes(String s, VertexFormat v, VertexFormat.Mode m, int i, boolean b, boolean b2, Runnable r, Runnable r2) {
        super(s, v, m, i, b, b2, r, r2);
        throw new IllegalStateException("This class is not meant to be constructed!");
    }

    public static class ShaderRenderType {
        private final String name;
        public ShaderInstance shader;
        private final RenderStateShard.ShaderStateShard shaderState = new RenderStateShard.ShaderStateShard(() -> this.shader);
        private final VertexFormat format;
        private final BiFunction<List<ShaderTexture>, ShaderRenderType, RenderType> builder;
        private final ResourceLocation shaderLocation;

        public ShaderRenderType(String name, VertexFormat format, BiFunction<List<ShaderTexture>, ShaderRenderType, RenderType> builder) {
            this.name = name;
            this.format = format;
            this.builder = Util.memoize(builder);
            this.shaderLocation = ResourceLocation.fromNamespaceAndPath((String)"wac", (String)this.name);
            this.using(Collections.emptyList());
        }

        public RenderType using(List<ShaderTexture> textures) {
            return this.builder.apply(textures, this);
        }

        public void register(ResourceProvider resourceManager, BiConsumer<ShaderInstance, Consumer<ShaderInstance>> registerFunc) throws IOException {
            registerFunc.accept(new ShaderInstance(resourceManager, this.shaderLocation().toString(), this.format), this::shader);
        }

        public String formattedName() {
            return "%s_%s".formatted("wac", this.name);
        }

        public ResourceLocation shaderLocation() {
            return this.shaderLocation;
        }

        public String name() {
            return this.name;
        }

        public VertexFormat format() {
            return this.format;
        }

        private void shader(ShaderInstance shader) {
            this.shader = shader;
        }

        public RenderStateShard.ShaderStateShard getShaderState() {
            return this.shaderState;
        }
    }
}

