/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.recipe.ritual;

import com.blamejared.wac.platform.Services;
import com.blamejared.wac.recipe.WACRecipes;
import com.blamejared.wac.recipe.ritual.RitualRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record Ritual(NonNullList<Ingredient> ingredients, MobEffectInstance output, int requiredEnchantingPower) implements Recipe<RitualRecipeInput>
{
    public boolean matches(RitualRecipeInput input, Level level) {
        if (input.enchantingPower() < this.requiredEnchantingPower) {
            return false;
        }
        NonNullList containerItems = NonNullList.create();
        int itemCount = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemStack = input.getItem(i);
            if (itemStack.isEmpty()) continue;
            ++itemCount;
            containerItems.add((Object)itemStack);
        }
        if (itemCount == this.ingredients.size()) {
            return Services.PLATFORM.findMatches((List<ItemStack>)containerItems, (List<Ingredient>)this.getIngredients());
        }
        return false;
    }

    public ItemStack assemble(RitualRecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return WACRecipes.RITUAL_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return WACRecipes.RITUAL_TYPE.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients();
    }

    public static class Serializer
    implements RecipeSerializer<Ritual> {
        public static final MapCodec<Ritual> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] array = (Ingredient[])list.toArray(Ingredient[]::new);
            if (array.length == 0) {
                return DataResult.error(() -> "No ingredients for ritual");
            }
            return array.length > 9 ? DataResult.error(() -> "Too many ingredients for ritual recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])array));
        }, DataResult::success).forGetter(Recipe::getIngredients), (App)MobEffectInstance.CODEC.fieldOf("output").forGetter(Ritual::output), (App)Codec.INT.fieldOf("enchanting_power").forGetter(Ritual::requiredEnchantingPower)).apply((Applicative)instance, Ritual::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Ritual> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<Ritual> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Ritual> streamCodec() {
            return STREAM_CODEC;
        }

        private static Ritual fromNetwork(RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            MobEffectInstance output = (MobEffectInstance)MobEffectInstance.STREAM_CODEC.decode((Object)buf);
            int enchantingPower = buf.readVarInt();
            return new Ritual((NonNullList<Ingredient>)nonnulllist, output, enchantingPower);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, Ritual ritual) {
            buf.writeVarInt(ritual.ingredients.size());
            for (Ingredient ingredient : ritual.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
            MobEffectInstance.STREAM_CODEC.encode((Object)buf, (Object)ritual.output);
            buf.writeVarInt(ritual.requiredEnchantingPower);
        }
    }
}

