/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.data;

import com.blamejared.wac.block.BookStackBlock;
import com.blamejared.wac.block.WACBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class WACBlockStatesProvider
extends BlockStateProvider {
    public WACBlockStatesProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "wac", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.horizontalBlock(WACBlocks.MOSSY_PODIUM.get(), (ModelFile)this.models().getExistingFile(this.modLoc("mossy_podium")));
        this.logBlock(WACBlocks.WILTED_LOG.get());
        this.axisBlock(WACBlocks.STRIPPED_WILTED_LOG.get(), this.modLoc("block/stripped_wilted_log_horizontal"), this.modLoc("block/stripped_wilted_log_top"));
        this.axisBlock(WACBlocks.STRIPPED_WILTED_WOOD.get(), this.modLoc("block/stripped_wilted_log_horizontal"), this.modLoc("block/stripped_wilted_log_horizontal"));
        this.axisBlock(WACBlocks.WILTED_WOOD.get(), this.blockTexture((Block)WACBlocks.WILTED_LOG.get()), this.blockTexture((Block)WACBlocks.WILTED_LOG.get()));
        this.simpleBlock(WACBlocks.WILTED_PLANKS.get());
        this.doorBlockWithRenderType(WACBlocks.WILTED_DOOR.get(), this.modLoc("block/wilted_door_bottom"), this.modLoc("block/wilted_door_top"), "cutout");
        ResourceLocation planks = this.modLoc("block/wilted_planks");
        this.stairsBlock(WACBlocks.WILTED_STAIRS.get(), planks);
        this.pressurePlateBlock(WACBlocks.WILTED_PRESSURE_PLATE.get(), planks);
        this.fenceBlock(WACBlocks.WILTED_FENCE.get(), planks);
        this.fenceGateBlock(WACBlocks.WILTED_FENCE_GATE.get(), planks);
        this.trapdoorBlockWithRenderType(WACBlocks.WILTED_TRAPDOOR.get(), this.modLoc("block/wilted_trapdoor"), true, "cutout");
        this.buttonBlock(WACBlocks.WILTED_BUTTON.get(), planks);
        this.simpleBlock((Block)WACBlocks.WILTED_SAPLING.get(), (ModelFile)((BlockModelBuilder)this.models().cross("wilted_sapling", this.modLoc("block/wilted_sapling"))).renderType("cutout"));
        this.simpleBlock((Block)WACBlocks.WILTED_LEAVES.get(), (ModelFile)((BlockModelBuilder)this.models().leaves("wilted_leaves", this.modLoc("block/wilted_leaves"))).renderType("cutout_mipped"));
        this.simpleBlock(WACBlocks.WILTED_BOOKSHELF.get(), (ModelFile)this.models().cubeColumn("block/wilted_bookshelf", this.modLoc("block/wilted_bookshelf"), this.modLoc("block/wilted_planks")));
        this.slabBlock(WACBlocks.WILTED_SLAB.get(), this.modLoc("block/wilted_planks"), this.modLoc("block/wilted_planks"));
        this.signBlock(WACBlocks.WILTED_SIGN.get(), WACBlocks.WILTED_WALL_SIGN.get(), this.modLoc("block/wilted_planks"));
        this.hangingSignBlock(WACBlocks.WILTED_HANGING_SIGN.get(), WACBlocks.WILTED_WALL_HANGING_SIGN.get(), this.modLoc("block/wilted_planks"));
        this.horizontalBlock((Block)WACBlocks.WILTED_SHELF.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/wilted_shelf")));
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(WACBlocks.BOOK_STACK.get());
        variantBuilder.forAllStates(state -> {
            Integer value = (Integer)state.getValue((Property)BookStackBlock.BOOKS);
            return ConfiguredModel.allYRotations((ModelFile)this.models().getExistingFile(this.modLoc("book_stack_" + value)), (int)0, (boolean)false);
        });
        this.horizontalBlock((Block)WACBlocks.WITCHY_DECOR.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/witchy_decor")));
        this.simpleBlock((Block)WACBlocks.WILTED_ALLIUM.get(), (ModelFile)((BlockModelBuilder)this.models().cross("wilted_allium", this.modLoc("block/wilted_allium"))).renderType("cutout"));
        this.simpleBlock((Block)WACBlocks.WILTED_DANDELION.get(), (ModelFile)((BlockModelBuilder)this.models().cross("wilted_dandelion", this.modLoc("block/wilted_dandelion"))).renderType("cutout"));
        this.simpleBlock((Block)WACBlocks.WILTED_LILY.get(), (ModelFile)((BlockModelBuilder)this.models().cross("wilted_lily", this.modLoc("block/wilted_lily"))).renderType("cutout"));
        this.simpleBlock((Block)WACBlocks.WILTED_ORCHID.get(), (ModelFile)((BlockModelBuilder)this.models().cross("wilted_orchid", this.modLoc("block/wilted_orchid"))).renderType("cutout"));
        this.simpleBlock((Block)WACBlocks.WILTED_ROSE.get(), (ModelFile)((BlockModelBuilder)this.models().cross("wilted_rose", this.modLoc("block/wilted_rose"))).renderType("cutout"));
        this.simpleBlock(WACBlocks.DEEPSLATE_BASIN.get(), (ModelFile)this.models().getExistingFile(this.modLoc("deepslate_basin")));
    }
}

