/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.wac.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BookStackBlock
extends Block {
    public static final MapCodec<BookStackBlock> CODEC = BookStackBlock.simpleCodec(BookStackBlock::new);
    public static final IntegerProperty BOOKS = IntegerProperty.create((String)"books", (int)1, (int)4);
    private static final VoxelShape ONE_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
    private static final VoxelShape TWO_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    private static final VoxelShape THREE_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    private static final VoxelShape FOUR_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);

    public BookStackBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().getItem() == this.asItem() && (Integer)state.getValue((Property)BOOKS) < 4 || super.canBeReplaced(state, useContext);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.is((Block)this)) {
            return (BlockState)blockstate.cycle((Property)BOOKS);
        }
        return super.getStateForPlacement(context);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Integer)state.getValue((Property)BOOKS)) {
            default: {
                return ONE_AABB;
            }
            case 2: {
                return TWO_AABB;
            }
            case 3: {
                return THREE_AABB;
            }
            case 4: 
        }
        return FOUR_AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BOOKS});
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public MapCodec<BookStackBlock> codec() {
        return CODEC;
    }
}

