package com.blamejared.slimyboyos.mixin.common;

import com.blamejared.slimyboyos.Constants;
import com.blamejared.slimyboyos.api.IAbsorber;
import com.blamejared.slimyboyos.platform.Services;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3218;

@Mixin(class_1309.class)
public abstract class MixinLivingEntity extends class_1297 implements IAbsorber {
    
    @Shadow
    public abstract boolean method_5805();
    
    @Unique
    public boolean slimyboyos$canAbsorb;
    
    public MixinLivingEntity(class_1299<?> $$0, class_1937 $$1) {
        
        super($$0, $$1);
    }
    
    @Inject(method = "tick", at = @At("HEAD"))
    public void slimyboyos$tick(CallbackInfo ci) {
        
        if(!(this.method_73183() instanceof class_3218 sl) || !this.method_5805() || !sl.method_64395()
                .method_76185(class_1928.field_19388)) {
            return;
        }
        if(this.field_6012 % 20 == 0) {
            this.slimyboyos$canAbsorb = this.method_5864().method_20210(Services.PLATFORM.getSlimeTag());
        }
        
        if(slimyboyos$canAbsorb) {
            if(!slimyboyos$getAbsorbedItem().method_7960()) {
                return;
            }
            
            class_238 boundingBox = this.method_5829();
            List<class_1542> entities = this.method_73183()
                    .method_18023(class_1299.field_6052, boundingBox, item -> item.method_5805() && !item.method_5863() && !item.method_6983()
                            .method_7960());
            entities.stream()
                    .filter(item -> !item.method_6983().method_31573(Constants.SLIMES_CANNOT_ABSORB.get()))
                    .findFirst()
                    .ifPresent(item -> {
                        class_1799 stack = item.method_6983();
                        class_1799 absorbedStack = stack.method_7971(1);
                        slimyboyos$setAbsorbedItem(absorbedStack);
                        if(stack.method_7960()) {
                            item.method_31472();
                        }
                    });
        }
    }
    
    @Inject(method = "dropAllDeathLoot", at = @At("TAIL"))
    public void slimyboyos$dropCustomDeathLoot(class_3218 level, class_1282 $$1, CallbackInfo ci) {
        
        if(!(this.method_73183() instanceof class_3218 sl) || !level.method_64395().method_76185(class_1928.field_19391)) {
            return;
        }
        class_1799 stack = slimyboyos$getAbsorbedItem();
        if(!stack.method_7960()) {
            method_5775(sl, stack);
        }
        
    }
    
    @Inject(method = "readAdditionalSaveData", at = @At("TAIL"))
    public void slimyboyos$load(class_11368 value, CallbackInfo ci) {
        
        value.method_71426("slimyboyos:absorbed_item", class_1799.field_24671).ifPresent(this::slimyboyos$setAbsorbedItem);
    }
    
}
