package com.blamejared.searchables.api.formatter;

import net.minecraft.class_2583;

/**
 * Extra context used by the {@link FormattingVisitor}.
 *
 * @param isKey Is the current expression a key
 * @param style The style to apply to the current expression
 * @param valid If the current expression is valid.
 */
public record FormattingContext(boolean isKey, class_2583 style, boolean valid) {
    
    public static FormattingContext empty() {
        
        return new FormattingContext(false, class_2583.field_24360, true);
    }
    
    public static FormattingContext key(class_2583 validStyle, boolean valid) {
        
        return new FormattingContext(true, valid ? validStyle : FormattingConstants.INVALID, valid);
    }
    
    public static FormattingContext literal(class_2583 validStyle, boolean valid) {
        
        return new FormattingContext(false, valid ? validStyle : FormattingConstants.INVALID, valid);
    }
    
    public class_2583 style(boolean valid) {
        
        return valid ? style() : FormattingConstants.INVALID;
    }
    
}