package com.blamejared.searchables.api.autcomplete;

import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.SearchablesConstants;
import com.blamejared.searchables.api.TokenRange;
import com.blamejared.searchables.api.formatter.FormattingVisitor;
import com.blamejared.searchables.mixin.AccessEditBox;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;

public class AutoCompletingEditBox<T> extends class_342 {
    
    private final FormattingVisitor formattingVisitor;
    private final CompletionVisitor completionVisitor;
    private final DelegatingConsumers<String> responders = new DelegatingConsumers<>();
    private final AutoComplete<T> autoComplete;
    
    public AutoCompletingEditBox(class_327 font, int x, int y, int width, int height, class_2561 message, SearchableType<T> type, Supplier<List<T>> entries) {
        
        this(font, x, y, width, height, null, message, type, entries);
    }
    
    public AutoCompletingEditBox(class_327 font, int x, int y, int width, int height, @Nullable class_342 thisBox, class_2561 message, SearchableType<T> type, Supplier<List<T>> entries) {
        
        super(font, x, y, width, height, thisBox, message);
        this.method_1880(Integer.MAX_VALUE);
        this.formattingVisitor = new FormattingVisitor(type);
        this.completionVisitor = new CompletionVisitor();
        this.autoComplete = new AutoComplete<>(type, this, entries, x, y + 2 + height, width, font.field_2000 + 2);
        method_47404(SearchablesConstants.COMPONENT_SEARCH);
        this.method_73210(this.formattingVisitor);
        this.method_1863(this.responders);
        addResponder(this.formattingVisitor);
        addResponder(this.completionVisitor);
        addResponder(this.autoComplete);
    }
    
    @Override
    public boolean method_25405(double xpos, double ypos) {
        
        return super.method_25405(xpos, ypos) || this.autoComplete.method_25405(xpos, ypos);
    }
    
    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        
        if(this.method_25370() && autoComplete.method_25402(event, doubleClick)) {
            return true;
        }
        if((method_25405(event.comp_4798(), event.comp_4799()) || autoComplete().method_25405(event.comp_4798(), event.comp_4799())) && event.comp_4800()
                .method_74233()) {
            this.method_1852("");
            return true;
        }
        return super.method_25402(event, doubleClick);
    }
    
    @Override
    public boolean method_25404(class_11908 event) {
        
        if(event.method_74234()) {
            this.autoComplete().scrollUp();
            return true;
        }
        if(event.method_74235()) {
            this.autoComplete().scrollDown();
            return true;
        }
        if(event.method_74230()) {
            this.autoComplete().insertSuggestion();
            return true;
        }
        if(event.comp_4795() == GLFW.GLFW_KEY_PAGE_DOWN) {
            this.autoComplete.scrollDown(this.autoComplete().maxSuggestions());
            return true;
        }
        if(event.comp_4795() == GLFW.GLFW_KEY_PAGE_UP) {
            this.autoComplete.scrollUp(this.autoComplete().maxSuggestions());
            return true;
        }
        return super.method_25404(event);
    }
    
    /**
     * Deletes the characters as the given {@link TokenRange}.
     *
     * @param range The range to delete characters from
     */
    public void deleteChars(TokenRange range) {
        
        if(!this.method_1882().isEmpty()) {
            if(!range.isEmpty()) {
                String newValue = range.delete(this.method_1882());
                if(this.getFilter().test(newValue)) {
                    this.method_1852(newValue);
                    this.method_1883(range.start(), false);
                }
            }
        }
    }
    
    public Predicate<String> getFilter() {
        
        return ((AccessEditBox) this).searchables$getFilter();
    }
    
    @Nullable
    public Consumer<String> getResponder() {
        
        return ((AccessEditBox) this).searchables$getResponder();
    }
    
    /**
     * Should not be used, use {@link AutoCompletingEditBox#addResponder(Consumer)} instead
     */
    @SuppressWarnings("DeprecatedIsStillUsed")
    @Override
    @Deprecated
    public void method_1863(Consumer<String> responder) {
        
        if(this.getResponder() == null) {
            super.method_1863(responders);
        } else {
            this.addResponder(responder);
        }
    }
    
    public void addResponder(Consumer<String> responder) {
        
        this.responders.addConsumer(responder);
    }
    
    public FormattingVisitor formattingVisitor() {
        
        return formattingVisitor;
    }
    
    public CompletionVisitor completionVisitor() {
        
        return completionVisitor;
    }
    
    public AutoComplete<T> autoComplete() {
        
        return autoComplete;
    }
    
    private static class DelegatingConsumers<T> implements Consumer<T> {
        
        private final List<Consumer<T>> consumers = new ArrayList<>();
        
        @Override
        public void accept(T t) {
            
            consumers.forEach(tConsumer -> tConsumer.accept(t));
        }
        
        public void addConsumer(Consumer<T> consumer) {
            
            this.consumers.add(consumer);
        }
        
    }
    
}
