/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters.block.entity;

import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.block.ISAbstractFurnaceBlock;
import com.blamejared.ironsmelters.mixin.AccessAbstractFurnaceBlockEntity;
import com.blamejared.ironsmelters.platform.Services;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;

public abstract class AbstractISBlockEntity
extends class_2609 {
    private final SmelterType type;
    private final class_2561 defaultName;
    private float tickAccumulator = 0.0f;

    protected AbstractISBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState, class_3956<? extends class_1874> recipeType) {
        super(type, pos, blockState, recipeType);
        class_2248 class_22482 = this.method_11010().method_26204();
        if (!(class_22482 instanceof ISAbstractFurnaceBlock)) {
            throw new IllegalStateException("Expected ISAbstractFurnaceBlock");
        }
        ISAbstractFurnaceBlock block = (ISAbstractFurnaceBlock)class_22482;
        this.type = block.smelterType();
        this.defaultName = block.method_9518();
    }

    protected class_2561 method_17823() {
        return this.defaultName;
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, AbstractISBlockEntity blockEntity) {
        boolean hasFuel;
        AccessAbstractFurnaceBlockEntity access = blockEntity.access();
        boolean wasLit = access.callIsLit();
        boolean changed = false;
        if (access.callIsLit()) {
            access.setLitTime(access.getLitTime() - 1);
        }
        class_1799 fuel = (class_1799)blockEntity.field_11984.get(1);
        class_1799 input = (class_1799)blockEntity.field_11984.get(0);
        boolean hasInput = !input.method_7960();
        boolean bl = hasFuel = !fuel.method_7960();
        if (access.callIsLit() || hasFuel && hasInput) {
            class_8786 recipeholder = null;
            if (hasInput) {
                recipeholder = access.getQuickCheck().method_42303((class_9695)new class_9696(input), level).orElse(null);
            }
            int maxStackSize = blockEntity.method_5444();
            if (!access.callIsLit() && Services.PLATFORM.canBurn(level.method_30349(), recipeholder, (class_2371<class_1799>)blockEntity.field_11984, maxStackSize, blockEntity)) {
                access.setLitTime(blockEntity.method_11200(fuel));
                access.setLitDuration(access.getLitTime());
                if (access.callIsLit()) {
                    changed = true;
                    if (hasFuel) {
                        class_1792 fuelItem = fuel.method_7909();
                        fuel.method_7934(1);
                        if (fuel.method_7960()) {
                            class_1792 remainder = fuelItem.method_7858();
                            blockEntity.field_11984.set(1, (Object)(remainder == null ? class_1799.field_8037 : new class_1799((class_1935)remainder)));
                        }
                    }
                }
            }
            if (access.callIsLit() && Services.PLATFORM.canBurn(level.method_30349(), recipeholder, (class_2371<class_1799>)blockEntity.field_11984, maxStackSize, blockEntity)) {
                blockEntity.tickAccumulator += blockEntity.type().config().get().furnaceMultiplier();
                int passedTicks = (int)Math.floor(blockEntity.tickAccumulator);
                blockEntity.tickAccumulator -= (float)passedTicks;
                access.setCookingProgress(access.getCookingProgress() + passedTicks);
                if (access.getCookingProgress() >= access.getCookingTotalTime()) {
                    blockEntity.tickAccumulator = 0.0f;
                    access.setCookingProgress(0);
                    access.setCookingTotalTime(AccessAbstractFurnaceBlockEntity.callGetTotalCookTime(level, blockEntity));
                    if (Services.PLATFORM.burn(level.method_30349(), recipeholder, (class_2371<class_1799>)blockEntity.field_11984, maxStackSize, blockEntity)) {
                        blockEntity.method_7662(recipeholder);
                    }
                    changed = true;
                }
            } else {
                blockEntity.tickAccumulator = 0.0f;
                access.setCookingProgress(0);
            }
        } else if (access.getCookingProgress() > 0) {
            blockEntity.tickAccumulator = 0.0f;
            access.setCookingProgress(class_3532.method_15340((int)(access.getCookingProgress() - 2), (int)0, (int)access.getCookingTotalTime()));
        }
        if (wasLit != access.callIsLit()) {
            changed = true;
            state = (class_2680)state.method_11657((class_2769)class_2363.field_11105, (Comparable)Boolean.valueOf(access.callIsLit()));
            level.method_8652(pos, state, 3);
        }
        if (changed) {
            AbstractISBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
    }

    private AccessAbstractFurnaceBlockEntity access() {
        return (AccessAbstractFurnaceBlockEntity)((Object)this);
    }

    public SmelterType type() {
        return this.type;
    }
}

