package com.blamejared.ironsmelters.component;

import com.blamejared.ironsmelters.Util;
import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.block.ISAbstractFurnaceBlock;
import com.blamejared.ironsmelters.block.ISBlocks;
import com.blamejared.ironsmelters.block.entity.AbstractISBlockEntity;
import com.blamejared.ironsmelters.registry.RegistryObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_9299;

public record Upgrade(Optional<SmelterType> from, SmelterType to, boolean keepData) implements class_9299 {
    
    public static final Predicate<class_2680> PREDICATE = block -> block.method_26204() == class_2246.field_10181 || block.method_26204() == class_2246.field_16334 || block.method_26204() == class_2246.field_16333;
    public static final Codec<Upgrade> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                            SmelterType.CODEC.optionalFieldOf("from").forGetter(Upgrade::from),
                            SmelterType.CODEC.fieldOf("to").forGetter(Upgrade::to),
                            Codec.BOOL.optionalFieldOf("keep_data", true).forGetter(Upgrade::keepData)
                    )
                    .apply(instance, Upgrade::new)
    );
    
    public boolean matches(class_2680 state) {
        
        if(state.method_26204() instanceof ISAbstractFurnaceBlock isafb) {
            return from().filter(type -> type == isafb.smelterType()).isPresent();
        }
        
        return from.isEmpty() && PREDICATE.test(state);
    }
    
    public boolean upgrade(class_3218 level, class_2680 blockState, class_2338 pos) {
        
        ISAbstractFurnaceBlock.Type type;
        if(blockState.method_26204() instanceof ISAbstractFurnaceBlock isafb) {
            type = isafb.type();
        } else if(blockState.method_26204() == class_2246.field_10181) {
            type = ISAbstractFurnaceBlock.Type.FURNACE;
        } else if(blockState.method_26204() == class_2246.field_16333) {
            type = ISAbstractFurnaceBlock.Type.BLAST_FURNACE;
        } else if(blockState.method_26204() == class_2246.field_16334) {
            type = ISAbstractFurnaceBlock.Type.SMOKER;
        } else {
            return false;
        }
        Map<SmelterType, RegistryObject<class_2248>> map = Collections.emptyMap();
        switch(type) {
            case FURNACE -> map = ISBlocks.FURNACES;
            case BLAST_FURNACE -> map = ISBlocks.BLAST_FURNACES;
            case SMOKER -> map = ISBlocks.SMOKER;
        }
        class_2680 newState = map.get(this.to()).get().method_9564();
        if(this.keepData()) {
            for(Map.Entry<class_2769<?>, Comparable<?>> entry : blockState.method_11656().entrySet()) {
                newState = newState.method_11657(entry.getKey(), Util.uncheck(entry.getValue()));
            }
        }
        class_2586 oldEntity = level.method_8321(pos);
        class_5455 registryAccess = level.method_30349();
        class_2487 save = oldEntity != null ? oldEntity.method_38244(registryAccess) : null;
        level.method_8544(pos);
        level.method_8652(pos, newState, class_2248.field_31036);
        if(this.keepData() && level.method_8321(pos) instanceof AbstractISBlockEntity aisbe && save != null) {
            aisbe.method_58690(save, registryAccess);
        }
        
        return true;
    }
    
    @Override
    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag) {
        
        tooltipAdder.accept(class_2561.method_43470("test"));
    }
    
}