package com.blamejared.ironsmelters.block;

import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.block.entity.AbstractISBlockEntity;
import com.blamejared.ironsmelters.block.entity.ISBlastFurnaceBlockEntity;
import com.blamejared.ironsmelters.block.entity.ISBlockEntityTypes;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3908;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ISBlastFurnaceBlock extends ISAbstractFurnaceBlock {
    
    public static final MapCodec<ISBlastFurnaceBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(method_54096(), SmelterType.CODEC.fieldOf("type")
            .forGetter(ISBlastFurnaceBlock::smelterType)).apply(instance, ISBlastFurnaceBlock::new));
    
    public ISBlastFurnaceBlock(class_2251 properties, SmelterType type) {
        
        super(properties, type, Type.BLAST_FURNACE);
    }
    
    public MapCodec<ISBlastFurnaceBlock> method_53969() {
        
        return field_46280;
    }
    
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        
        return level.field_9236 ? null : method_31618(blockEntityType, ISBlockEntityTypes.BLAST_FURNACE.get(), AbstractISBlockEntity::serverTick);
    }
    
    @Override
    protected void method_17025(class_1937 level, class_2338 blockPos, class_1657 player) {
        
        class_2586 blockentity = level.method_8321(blockPos);
        if(blockentity instanceof AbstractISBlockEntity) {
            player.method_17355((class_3908) blockentity);
            player.method_7281(class_3468.field_17272);
        }
    }
    
    @Override
    public @Nullable class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        
        return new ISBlastFurnaceBlockEntity(blockPos, blockState);
    }
    
    @Override
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        
        if(state.method_11654(field_11105)) {
            double x = pos.method_10263() + 0.5;
            double y = pos.method_10264();
            double z = pos.method_10260() + 0.5;
            if(random.method_43058() < 0.1) {
                level.method_8486(x, y, z, class_3417.field_17605, class_3419.field_15245, 1.0F, 1.0F, false);
            }
            
            class_2350 direction = state.method_11654(field_11104);
            class_2350.class_2351 axis = direction.method_10166();
            double offset = 0.52;
            double hOffset = random.method_43058() * 0.6 - 0.3;
            double xOffset = axis == class_2350.class_2351.field_11048 ? direction.method_10148() * offset : hOffset;
            double yOffset = random.method_43058() * 6.0 / 16.0;
            double zOffset = axis == class_2350.class_2351.field_11051 ? direction.method_10165() * offset : hOffset;
            level.method_8406(class_2398.field_11251, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }
    
}
