/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.darkhax.pricklemc.common.api.annotations.Value;

public final class SmelterConfig {
    public static final Codec<SmelterConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("furnaceMultiplier").forGetter(SmelterConfig::furnaceMultiplier), (App)Codec.FLOAT.fieldOf("blastFurnaceMultiplier").forGetter(SmelterConfig::blastFurnaceMultiplier), (App)Codec.FLOAT.fieldOf("smokerMultiplier").forGetter(SmelterConfig::smokerMultiplier)).apply((Applicative)instance, SmelterConfig::new));
    @Value(name="Furnace Speed Multiplier", comment="How fast items are smelted compared to the vanilla Furnace.")
    private float furnaceMultiplier;
    @Value(name="Blast Furnace Speed Multiplier", comment="How fast items are smelted compared to the vanilla Blast Furnace.")
    private float blastFurnaceMultiplier;
    @Value(name="Smoker Speed Multiplier", comment="How fast items are smelted compared to the vanilla Smoker.")
    private float smokerMultiplier;

    public SmelterConfig(float furnaceMultiplier, float blastFurnaceMultiplier, float smokerMultiplier) {
        this.furnaceMultiplier = furnaceMultiplier;
        this.blastFurnaceMultiplier = blastFurnaceMultiplier;
        this.smokerMultiplier = smokerMultiplier;
    }

    public float furnaceMultiplier() {
        return this.furnaceMultiplier;
    }

    public float blastFurnaceMultiplier() {
        return this.blastFurnaceMultiplier;
    }

    public float smokerMultiplier() {
        return this.smokerMultiplier;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SmelterConfig that = (SmelterConfig)obj;
        return Float.floatToIntBits(this.furnaceMultiplier) == Float.floatToIntBits(that.furnaceMultiplier) && Float.floatToIntBits(this.blastFurnaceMultiplier) == Float.floatToIntBits(that.blastFurnaceMultiplier) && Float.floatToIntBits(this.smokerMultiplier) == Float.floatToIntBits(that.smokerMultiplier);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.furnaceMultiplier), Float.valueOf(this.blastFurnaceMultiplier), Float.valueOf(this.smokerMultiplier));
    }

    public String toString() {
        return "SmelterConfig[furnaceMultiplier=" + this.furnaceMultiplier + ", blastFurnaceMultiplier=" + this.blastFurnaceMultiplier + ", smokerMultiplier=" + this.smokerMultiplier + "]";
    }
}

