package com.blamejared.ironsmelters.block.entity;

import com.blamejared.ironsmelters.ISConstants;
import com.blamejared.ironsmelters.block.ISBlocks;
import com.blamejared.ironsmelters.platform.IRegister;
import com.blamejared.ironsmelters.platform.Services;
import com.blamejared.ironsmelters.registry.RegistrationProvider;
import com.blamejared.ironsmelters.registry.RegistryObject;
import com.google.auto.service.AutoService;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_7924;

@SuppressWarnings("DataFlowIssue")
@AutoService(IRegister.class)
public class ISBlockEntityTypes implements IRegister {
    
    private static final RegistrationProvider<class_2591<?>> BLOCK_ENTITY_TYPES = RegistrationProvider.get(class_7924.field_41255, ISConstants.MODID);
    
    public static final RegistryObject<class_2591<ISFurnaceBlockEntity>> FURNACE = BLOCK_ENTITY_TYPES.register("furnace", () -> Services.PLATFORM.blockEntityBuilder(ISFurnaceBlockEntity::new, ISBlocks.FURNACES.values()
                    .stream()
                    .map(RegistryObject::get)
                    .toArray(class_2248[]::new))
            .method_11034(null));
    
    public static final RegistryObject<class_2591<ISBlastFurnaceBlockEntity>> BLAST_FURNACE = BLOCK_ENTITY_TYPES.register("blast_furnace", () -> Services.PLATFORM.blockEntityBuilder(ISBlastFurnaceBlockEntity::new, ISBlocks.BLAST_FURNACES.values()
                    .stream()
                    .map(RegistryObject::get)
                    .toArray(class_2248[]::new))
            .method_11034(null));
    
    
    public static final RegistryObject<class_2591<ISSmokerBlockEntity>> SMOKER = BLOCK_ENTITY_TYPES.register("smoker", () -> Services.PLATFORM.blockEntityBuilder(ISSmokerBlockEntity::new, ISBlocks.SMOKER.values()
                    .stream()
                    .map(RegistryObject::get)
                    .toArray(class_2248[]::new))
            .method_11034(null));
    
}
