package com.blamejared.ironsmelters.registry;

import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

/**
 * Represents a lazy wrapper for registry object.
 *
 * @param <T> the type of the object
 */
public interface RegistryObject<T> extends Supplier<T> {
    
    /**
     * Gets the {@link class_5321} of the registry of the object wrapped.
     *
     * @return the {@link class_5321} of the registry
     */
    class_5321<T> getResourceKey();
    
    /**
     * Gets the id of the object.
     *
     * @return the id of the object
     */
    class_2960 getId();
    
    /**
     * Gets the object behind this wrapper. Calling this method too early
     * might result in crashes.
     *
     * @return the object behind this wrapper
     */
    @Override
    T get();
    
    /**
     * Gets this object wrapped in a vanilla {@link class_6880}.
     *
     * @return the holder
     */
    class_6880<T> asHolder();
    
}
