package com.blamejared.ironsmelters.platform;

import com.blamejared.ironsmelters.registry.RegistrationProvider;
import com.blamejared.ironsmelters.registry.RegistryObject;
import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@AutoService(RegistrationProvider.Factory.class)
public class FabricRegistrationFactory implements RegistrationProvider.Factory {
    
    @Override
    public <T> RegistrationProvider<T> create(class_5321<? extends class_2378<T>> resourceKey, String modId) {
        
        return new Provider<>(modId, resourceKey);
    }
    
    @Override
    public <T> RegistrationProvider<T> create(class_2378<T> registry, String modId) {
        
        return new Provider<>(modId, registry);
    }
    
    private static class Provider<T> implements RegistrationProvider<T> {
        
        private final String modId;
        private final class_2378<T> registry;
        
        private final Set<RegistryObject<T>> entries = new HashSet<>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(entries);
        
        @SuppressWarnings({"unchecked"})
        private Provider(String modId, class_5321<? extends class_2378<T>> key) {
            
            this.modId = modId;
            
            final var reg = class_7923.field_41167.method_10223(key.method_29177());
            if(reg == null) {
                throw new RuntimeException("Registry with name " + key.method_29177() + " was not found!");
            }
            registry = (class_2378<T>) reg;
        }
        
        private Provider(String modId, class_2378<T> registry) {
            
            this.modId = modId;
            this.registry = registry;
        }
        
        @Override
        @SuppressWarnings("unchecked")
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            
            final var rl = class_2960.method_60655(modId, name);
            final var obj = class_2378.method_10230(registry, rl, supplier.get());
            final var ro = new RegistryObject<I>() {
                final class_5321<I> key = class_5321.method_29179((class_5321<? extends class_2378<I>>) registry.method_30517(), rl);
                
                @Override
                public class_5321<I> getResourceKey() {
                    
                    return key;
                }
                
                @Override
                public class_2960 getId() {
                    
                    return rl;
                }
                
                @Override
                public I get() {
                    
                    return obj;
                }
                
                @Override
                public class_6880<I> asHolder() {
                    
                    return (class_6880<I>) registry.method_31140((class_5321<T>) this.key);
                }
            };
            entries.add((RegistryObject<T>) ro);
            return ro;
        }
        
        @Override
        public Collection<RegistryObject<T>> getEntries() {
            
            return entriesView;
        }
        
        @Override
        public String getModId() {
            
            return modId;
        }
        
        @Override
        public class_5321<? extends class_2378<T>> resourceKey() {
            
            return this.registry.method_30517();
        }
        
    }
    
}