package com.blamejared.ironsmelters;

import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.component.ISComponents;
import com.blamejared.ironsmelters.component.Upgrade;
import com.blamejared.ironsmelters.item.ISItems;
import com.blamejared.ironsmelters.platform.IRegister;
import com.blamejared.ironsmelters.platform.Services;
import com.blamejared.ironsmelters.registry.RegistryObject;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class ISCommon {
    
    public static void init() {
        // Initialize all registry providers
        Services.loadAll(IRegister.class).forEach(ServiceLoader.Provider::get);
    }
    
    public static boolean interact(class_1657 player, class_1937 level, class_1799 stack, class_2338 pos) {
        
        if(!player.method_7325() && level instanceof class_3218 sl && stack.method_57826(ISComponents.UPGRADE.get())) {
            Upgrade upgrade = Objects.requireNonNull(stack.method_57824(ISComponents.UPGRADE.get()));
            class_2680 blockState = sl.method_8320(pos);
            if(upgrade.matches(blockState) && upgrade.upgrade(sl, blockState, pos)) {
                stack.method_57008(1, player);
                return true;
            }
        }
        return false;
    }
    
    public static void registerCreativeTabs(Consumer<class_1935> registrar) {
        
        for(SmelterType value : SmelterType.ALL.values()) {
            registrar.accept(ISItems.FURNACES.get(value).get());
        }
        for(SmelterType value : SmelterType.ALL.values()) {
            registrar.accept(ISItems.BLAST_FURNACES.get(value).get());
        }
        for(SmelterType value : SmelterType.ALL.values()) {
            registrar.accept(ISItems.SMOKERS.get(value).get());
        }
        
        for(RegistryObject<class_1792> value : ISItems.UPGRADES.values()) {
            class_1792 item = value.get();
            registrar.accept(item);
        }
    }
    
}
