/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters;

import com.blamejared.ironsmelters.api.SmelterType;
import com.blamejared.ironsmelters.component.ISComponents;
import com.blamejared.ironsmelters.component.Upgrade;
import com.blamejared.ironsmelters.item.ISItems;
import com.blamejared.ironsmelters.platform.IRegister;
import com.blamejared.ironsmelters.platform.Services;
import com.blamejared.ironsmelters.registry.RegistryObject;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ISCommon {
    public static void init() {
        Services.loadAll(IRegister.class).forEach(ServiceLoader.Provider::get);
    }

    public static boolean interact(Player player, Level level, ItemStack stack, BlockPos pos) {
        if (!player.isSpectator() && level instanceof ServerLevel) {
            BlockState blockState;
            Upgrade upgrade;
            ServerLevel sl = (ServerLevel)level;
            if (stack.has(ISComponents.UPGRADE.get()) && (upgrade = Objects.requireNonNull((Upgrade)stack.get(ISComponents.UPGRADE.get()))).matches(blockState = sl.getBlockState(pos)) && upgrade.upgrade(sl, blockState, pos)) {
                stack.consume(1, (LivingEntity)player);
                return true;
            }
        }
        return false;
    }

    public static void registerCreativeTabs(Consumer<ItemLike> registrar) {
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            registrar.accept((ItemLike)ISItems.FURNACES.get(smelterType).get());
        }
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            registrar.accept((ItemLike)ISItems.BLAST_FURNACES.get(smelterType).get());
        }
        for (SmelterType smelterType : SmelterType.ALL.values()) {
            registrar.accept((ItemLike)ISItems.SMOKERS.get(smelterType).get());
        }
        for (RegistryObject registryObject : ISItems.UPGRADES.values()) {
            Item item = (Item)registryObject.get();
            registrar.accept((ItemLike)item);
        }
    }
}

