/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ironsmelters.registry;

import com.blamejared.ironsmelters.Util;
import com.blamejared.ironsmelters.platform.Services;
import com.blamejared.ironsmelters.registry.RegistryObject;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public interface RegistrationProvider<T> {
    public static <T> RegistrationProvider<T> get(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        return Factory.INSTANCE.create(resourceKey, modId);
    }

    public static <T> RegistrationProvider<T> get(Registry<T> registry, String modId) {
        return Factory.INSTANCE.create(registry, modId);
    }

    public <I extends T> RegistryObject<I> register(String var1, Supplier<? extends I> var2);

    default public <I extends T> RegistryObject<I> block(String name, Function<BlockBehaviour.Properties, ? extends I> supplier) {
        return this.register(name, () -> {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)name);
            ResourceKey rk = ResourceKey.create((ResourceKey)((ResourceKey)Util.uncheck(this.resourceKey())), (ResourceLocation)location);
            return supplier.apply(BlockBehaviour.Properties.of());
        });
    }

    default public <I extends T> RegistryObject<I> block(String name, Function<BlockBehaviour.Properties, ? extends I> supplier, BlockBehaviour.Properties defaultProperties) {
        return this.register(name, () -> {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)name);
            ResourceKey rk = ResourceKey.create((ResourceKey)((ResourceKey)Util.uncheck(this.resourceKey())), (ResourceLocation)location);
            return supplier.apply(defaultProperties);
        });
    }

    default public <I extends T> RegistryObject<I> item(String name, Function<Item.Properties, ? extends I> supplier) {
        return this.register(name, () -> {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)name);
            ResourceKey rk = ResourceKey.create((ResourceKey)((ResourceKey)Util.uncheck(this.resourceKey())), (ResourceLocation)location);
            return supplier.apply(new Item.Properties());
        });
    }

    default public <I extends T> RegistryObject<I> item(String name, Function<Item.Properties, ? extends I> supplier, Item.Properties defaultProperties) {
        return this.register(name, () -> {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)name);
            ResourceKey rk = ResourceKey.create((ResourceKey)((ResourceKey)Util.uncheck(this.resourceKey())), (ResourceLocation)location);
            return supplier.apply(defaultProperties);
        });
    }

    default public <I extends T> RegistryObject<I> blockItem(String name, RegistryObject<Block> block, UnaryOperator<Item.Properties> supplier) {
        return this.register(name, () -> {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)name);
            ResourceKey rk = ResourceKey.create((ResourceKey)((ResourceKey)Util.uncheck(this.resourceKey())), (ResourceLocation)location);
            return Util.uncheck(new BlockItem((Block)block.get(), (Item.Properties)supplier.apply(new Item.Properties())));
        });
    }

    default public <I extends T> RegistryObject<I> blockItem(String name, RegistryObject<Block> block, UnaryOperator<Item.Properties> supplier, Item.Properties defaultProperties) {
        return this.register(name, () -> {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)name);
            ResourceKey rk = ResourceKey.create((ResourceKey)((ResourceKey)Util.uncheck(this.resourceKey())), (ResourceLocation)location);
            return Util.uncheck(new BlockItem((Block)block.get(), (Item.Properties)supplier.apply(defaultProperties)));
        });
    }

    public Collection<RegistryObject<T>> getEntries();

    public String getModId();

    public ResourceKey<? extends Registry<T>> resourceKey();

    public static interface Factory {
        public static final Factory INSTANCE = Services.load(Factory.class);

        public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> var1, String var2);

        default public <T> RegistrationProvider<T> create(Registry<T> registry, String modId) {
            return this.create(registry.key(), modId);
        }
    }
}

