/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.entries.ICategoryEntry;
import com.blamejared.controlling.api.entries.IKeyEntry;
import com.blamejared.controlling.api.events.IKeyEntryListenersEvent;
import com.blamejared.controlling.api.events.IKeyEntryMouseClickedEvent;
import com.blamejared.controlling.api.events.IKeyEntryMouseReleasedEvent;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.platform.Services;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.options.controls.KeyBindsList;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.apache.commons.lang3.ArrayUtils;

public class NewKeyBindsList
extends CustomList {
    private final KeyBindsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;

    public NewKeyBindsList(KeyBindsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.height -= 52;
        this.setY(48);
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.clearEntries();
        this.allEntries = new ArrayList();
        Object[] bindings = (KeyMapping[])ArrayUtils.clone((Object[])mcIn.options.keyMappings);
        Arrays.sort(bindings);
        KeyMapping.Category lastCategory = null;
        for (Object keybinding : bindings) {
            Component component;
            int width;
            KeyMapping.Category category = keybinding.getCategory();
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                if (!this.isHidden(category.label())) {
                    this.addEntry(new CategoryEntry(category));
                }
            }
            if ((width = mcIn.font.width((FormattedText)(component = Services.PLATFORM.getKeyName((KeyMapping)keybinding)))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = width;
            }
            if (this.isHidden(category.label())) continue;
            this.addEntry(new KeyEntry((KeyMapping)keybinding, component));
        }
    }

    private boolean isHidden(Component component) {
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            return tc.getKey().endsWith(".hidden");
        }
        return false;
    }

    public int getBottom() {
        return this.controlsScreen.height - 56;
    }

    public class CategoryEntry
    extends KeyBindsList.Entry
    implements ICategoryEntry {
        private final KeyMapping.Category category;
        private final FocusableTextWidget categoryName;

        public CategoryEntry(KeyMapping.Category category) {
            this.category = category;
            this.categoryName = FocusableTextWidget.builder((Component)category.label(), (Font)((NewKeyBindsList)NewKeyBindsList.this).minecraft.font).alwaysShowBorder(false).backgroundFill(FocusableTextWidget.BackgroundFill.ON_FOCUS).build();
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.categoryName.setPosition(NewKeyBindsList.this.width / 2 - this.categoryName.getWidth() / 2, this.getContentBottom() - 9 - 1);
            this.categoryName.render(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of(this.categoryName);
        }

        public List<? extends GuiEventListener> children() {
            return List.of(this.categoryName);
        }

        protected void refreshEntry() {
        }

        public FocusableTextWidget categoryName() {
            return this.categoryName;
        }

        @Override
        public KeyMapping.Category category() {
            return this.category;
        }
    }

    public class KeyEntry
    extends KeyBindsList.Entry
    implements IKeyEntry {
        private final KeyMapping key;
        private final Component keyDesc;
        private final Button btnChangeKeyBinding;
        private final Button btnResetKeyBinding;
        private boolean hasCollision;
        private final Component categoryName;

        public KeyEntry(KeyMapping key, Component keyDesc) {
            this.key = key;
            this.keyDesc = keyDesc;
            this.btnChangeKeyBinding = Button.builder((Component)this.keyDesc, btn -> {
                NewKeyBindsList.this.controlsScreen.selectedKey = key;
                NewKeyBindsList.this.resetMappingAndUpdateButtons();
            }).bounds(0, 0, 75, 20).createNarration(supp -> key.isUnbound() ? Component.translatable((String)"narrator.controls.unbound", (Object[])new Object[]{keyDesc}) : Component.translatable((String)"narrator.controls.bound", (Object[])new Object[]{keyDesc, supp.get()})).build();
            this.btnResetKeyBinding = Button.builder((Component)ControllingConstants.COMPONENT_CONTROLS_RESET, btn -> {
                Services.PLATFORM.setToDefault(((NewKeyBindsList)NewKeyBindsList.this).minecraft.options, key);
                NewKeyBindsList.this.resetMappingAndUpdateButtons();
            }).bounds(0, 0, 50, 20).createNarration(supp -> Component.translatable((String)"narrator.controls.reset", (Object[])new Object[]{keyDesc})).build();
            this.categoryName = this.key.getCategory().label();
            this.refreshEntry();
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Services.EVENT.fireKeyEntryRenderEvent(this, guiGraphics, this.getContentX(), this.getContentY(), NewKeyBindsList.this.getRowLeft(), NewKeyBindsList.this.getRowWidth(), hovered, partialTicks);
            int resetKeyX = NewKeyBindsList.this.scrollBarX() - this.btnResetKeyBinding.getWidth() - 10;
            int top = this.getContentY() - 2;
            this.btnResetKeyBinding.setPosition(resetKeyX, top);
            this.btnResetKeyBinding.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.btnChangeKeyBinding.setPosition(resetKeyX - 5 - this.btnChangeKeyBinding.getWidth(), top);
            this.btnChangeKeyBinding.render(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.drawString(NewKeyBindsList.this.mc.font, this.keyDesc, this.getContentX(), this.getContentYMiddle() - 4, -1);
            if (this.hasCollision) {
                int markerWidth = 3;
                int minX = this.btnChangeKeyBinding.getX() - 6;
                guiGraphics.fill(minX, this.getContentY() - 1, minX + markerWidth, this.getContentBottom(), -256);
            }
        }

        @Override
        public List<GuiEventListener> children() {
            return (List)Services.EVENT.fireKeyEntryListenersEvent(this).map(IKeyEntryListenersEvent::getListeners, UnaryOperator.identity());
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.btnChangeKeyBinding, (Object)this.btnResetKeyBinding);
        }

        @Override
        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            if (((Boolean)Services.EVENT.fireKeyEntryMouseClickedEvent(this, event, doubleClick).map(IKeyEntryMouseClickedEvent::isHandled, UnaryOperator.identity())).booleanValue()) {
                return true;
            }
            return super.mouseClicked(event, doubleClick);
        }

        @Override
        public boolean mouseReleased(MouseButtonEvent event) {
            if (((Boolean)Services.EVENT.fireKeyEntryMouseReleasedEvent(this, event).map(IKeyEntryMouseReleasedEvent::isHandled, UnaryOperator.identity())).booleanValue()) {
                return true;
            }
            return super.mouseReleased(event);
        }

        @Override
        public KeyMapping getKey() {
            return this.key;
        }

        @Override
        public Component getKeyDesc() {
            return this.keyDesc;
        }

        @Override
        public Component categoryName() {
            return this.categoryName;
        }

        @Override
        public Button getBtnResetKeyBinding() {
            return this.btnResetKeyBinding;
        }

        @Override
        public Button getBtnChangeKeyBinding() {
            return this.btnChangeKeyBinding;
        }

        protected void refreshEntry() {
            this.btnChangeKeyBinding.setMessage(this.key.getTranslatedKeyMessage());
            this.btnResetKeyBinding.active = !this.key.isDefault();
            this.hasCollision = false;
            MutableComponent duplicates = Component.empty();
            if (!this.key.isUnbound()) {
                KeyMapping[] mappings;
                for (KeyMapping mapping : mappings = ((NewKeyBindsList)NewKeyBindsList.this).minecraft.options.keyMappings) {
                    if ((mapping == this.key || !this.key.same(mapping)) && !Services.PLATFORM.hasConflictingModifier(this.key, mapping)) continue;
                    if (this.hasCollision) {
                        duplicates.append(", ");
                    }
                    this.hasCollision = true;
                    duplicates.append(Services.PLATFORM.getKeyName(mapping));
                }
            }
            MutableComponent tooltip = this.categoryName.copy();
            if (this.hasCollision) {
                this.btnChangeKeyBinding.setMessage((Component)Component.literal((String)"[ ").append((Component)this.btnChangeKeyBinding.getMessage().copy().withStyle(ChatFormatting.WHITE)).append(" ]").withStyle(ChatFormatting.YELLOW));
                tooltip.append(CommonComponents.NEW_LINE);
                tooltip.append((Component)Component.translatable((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{duplicates}));
            }
            this.btnChangeKeyBinding.setTooltip(Tooltip.create((Component)tooltip));
            if (NewKeyBindsList.this.controlsScreen.selectedKey == this.key) {
                this.btnChangeKeyBinding.setMessage((Component)Component.literal((String)"> ").append((Component)this.btnChangeKeyBinding.getMessage().copy().withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE})).append(" <").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

