/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.DisplayMode;
import com.blamejared.controlling.api.SortOrder;
import com.blamejared.controlling.api.entries.IKeyEntry;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.client.DisplayableBoolean;
import com.blamejared.controlling.client.FreeKeysList;
import com.blamejared.controlling.client.NewKeyBindsList;
import com.blamejared.controlling.mixin.AccessAbstractSelectionList;
import com.blamejared.controlling.mixin.AccessKeyBindsScreen;
import com.blamejared.controlling.platform.Services;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsList;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class NewKeyBindsScreen
extends KeyBindsScreen {
    private AutoCompletingEditBox<KeyBindsList.Entry> search;
    private DisplayMode displayMode;
    private SortOrder sortOrder = SortOrder.NONE;
    private Button buttonNone;
    private Button buttonConflicting;
    private Button buttonSort;
    private final DisplayableBoolean confirmingReset = new DisplayableBoolean(false, (Component)ControllingConstants.COMPONENT_OPTIONS_CONFIRM_RESET, (Component)ControllingConstants.COMPONENT_CONTROLS_RESET_ALL);
    private boolean showFree;
    private Supplier<NewKeyBindsList> newKeyList;
    private Supplier<FreeKeysList> freeKeyList;
    private final Button.OnPress PRESS_RESET = btn -> {
        NewKeyBindsScreen screen = this;
        Minecraft minecraft = Objects.requireNonNull(screen.minecraft);
        if (!this.confirmingReset.toggle()) {
            for (KeyMapping keybinding : minecraft.options.keyMappings) {
                Services.PLATFORM.setToDefault(minecraft.options, keybinding);
            }
            this.getKeyBindsList().resetMappingAndUpdateButtons();
        }
        btn.setMessage(this.confirmingReset.currentDisplay());
    };
    private final Button.OnPress PRESS_NONE = btn -> {
        if (this.displayMode == DisplayMode.NONE) {
            this.buttonNone.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.NONE;
            this.buttonNone.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonConflicting.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
        }
        this.filterKeys();
    };
    private final Button.OnPress PRESS_SORT = btn -> {
        this.sortOrder = this.sortOrder.cycle();
        btn.setMessage(this.sortOrder.getDisplay());
        this.filterKeys();
    };
    private final Button.OnPress PRESS_CONFLICTING = btn -> {
        if (this.displayMode == DisplayMode.CONFLICTING) {
            this.buttonConflicting.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.CONFLICTING;
            this.buttonConflicting.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonNone.setMessage((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
        }
        this.filterKeys();
    };
    private final Button.OnPress PRESS_FREE = btn -> {
        this.removeWidget((GuiEventListener)this.getKeyBindsList());
        if (this.showFree) {
            this.buttonSort.active = true;
            this.buttonNone.active = true;
            this.buttonConflicting.active = true;
            this.resetButton().active = this.canReset();
            this.setKeyBindsList(this.newKeyList.get());
        } else {
            this.freeKeyList.get().recalculate();
            this.buttonSort.active = false;
            this.buttonNone.active = false;
            this.buttonConflicting.active = false;
            this.resetButton().active = false;
            this.setKeyBindsList(this.freeKeyList.get());
        }
        this.filterKeys();
        this.addRenderableWidget((GuiEventListener)this.getKeyBindsList());
        this.setFocused((GuiEventListener)this.getKeyBindsList());
        this.showFree = !this.showFree;
    };

    public NewKeyBindsScreen(Screen screen, Options settings) {
        super(screen, settings);
        this.layout.setHeaderHeight(48);
        this.layout.setFooterHeight(56);
    }

    protected void init() {
        super.init();
        this.search.moveCursor(0, false);
    }

    protected void addTitle() {
        int searchX = 340;
        int centerX = this.width / 2;
        Supplier<List> listSupplier = () -> this.getCustomList().getAllEntries();
        this.search = new AutoCompletingEditBox(this.font, centerX - searchX / 2, 20, searchX, 20, this.search, (Component)Component.translatable((String)"selectWorld.search"), ControllingConstants.SEARCHABLE_KEYBINDINGS, listSupplier);
        this.search.addResponder(this::filterKeys);
        LinearLayout header = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical(), layoutSettings -> layoutSettings.paddingVertical(8));
        header.addChild((LayoutElement)new StringWidget(this.title, this.font), LayoutSettings::alignHorizontallyCenter);
        header.addChild(this.search, layoutSettings -> layoutSettings.paddingVertical(4));
        this.setInitialFocus((GuiEventListener)this.search);
    }

    protected void addContents() {
        this.newKeyList = Suppliers.memoize(() -> new NewKeyBindsList(this, this.minecraft));
        this.freeKeyList = () -> new FreeKeysList(this, this.minecraft);
        this.getAccess().controlling$setKeyBindsList(this.showFree ? (KeyBindsList)this.freeKeyList.get() : (KeyBindsList)this.newKeyList.get());
        this.layout.addToContents((LayoutElement)this.getKeyBindsList());
        this.displayMode = DisplayMode.ALL;
    }

    protected void addFooter() {
        int btnWidth = 74;
        this.resetButton(Button.builder((Component)this.confirmingReset.currentDisplay(), (Button.OnPress)this.PRESS_RESET).build());
        this.resetButton().active = this.canReset();
        Button toggleFreeButton = Button.builder((Component)ControllingConstants.COMPONENT_OPTIONS_TOGGLE_FREE, (Button.OnPress)this.PRESS_FREE).size(btnWidth, 20).build();
        this.buttonSort = Button.builder((Component)this.sortOrder.getDisplay(), (Button.OnPress)this.PRESS_SORT).size(btnWidth, 20).build();
        this.buttonNone = Button.builder((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE, (Button.OnPress)this.PRESS_NONE).size(btnWidth, 20).build();
        this.buttonConflicting = Button.builder((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS, (Button.OnPress)this.PRESS_CONFLICTING).size(btnWidth, 20).build();
        GridLayout grid = (GridLayout)this.layout.addToFooter((LayoutElement)new GridLayout());
        grid.rowSpacing(4);
        grid.columnSpacing(8);
        GridLayout.RowHelper rowHelper = grid.createRowHelper(2);
        LinearLayout topLeft = (LinearLayout)rowHelper.addChild((LayoutElement)LinearLayout.horizontal());
        topLeft.spacing(4);
        topLeft.addChild((LayoutElement)toggleFreeButton);
        topLeft.addChild((LayoutElement)this.buttonSort);
        LinearLayout topRight = (LinearLayout)rowHelper.addChild((LayoutElement)LinearLayout.horizontal());
        topRight.spacing(4);
        topRight.addChild((LayoutElement)this.buttonNone);
        topRight.addChild((LayoutElement)this.buttonConflicting);
        rowHelper.addChild((LayoutElement)this.resetButton());
        rowHelper.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).build());
    }

    protected void repositionElements() {
        super.repositionElements();
        this.resetButton().active = this.canReset();
    }

    public void render(GuiGraphics guiGraphics, int mxPos, int myPos, float partialTicks) {
        super.render(guiGraphics, mxPos, myPos, partialTicks);
        this.search.autoComplete().render(guiGraphics, mxPos, myPos, partialTicks);
    }

    public Button resetButton() {
        return this.getAccess().controlling$getResetButton();
    }

    public void resetButton(Button button) {
        this.getAccess().controlling$setResetButton(button);
    }

    public void filterKeys() {
        this.filterKeys(this.search.getValue());
    }

    public void filterKeys(String lastSearch) {
        CustomList list = this.getCustomList();
        list.clearEntries();
        this.getKeyBindsList().setScrollAmount(0.0);
        if (lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
            for (KeyBindsList.Entry allEntry : this.getCustomList().getAllEntries()) {
                list.addEntryInternal(allEntry);
            }
            return;
        }
        Predicate<KeyBindsList.Entry> extraPredicate = entry -> true;
        Consumer<List> postConsumer = entries -> {};
        if (list instanceof NewKeyBindsList) {
            extraPredicate = this.displayMode.getPredicate();
            postConsumer = entries -> {
                entries.removeIf(entry -> !(entry instanceof IKeyEntry));
                list.sort(this.sortOrder);
            };
        }
        List entries2 = ControllingConstants.SEARCHABLE_KEYBINDINGS.filterEntries(list.getAllEntries(), lastSearch, extraPredicate);
        for (KeyBindsList.Entry entry2 : entries2) {
            list.addEntryInternal(entry2);
        }
        postConsumer.accept(this.getAbstractSelectionList().controlling$getChildren());
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        boolean b = super.mouseClicked(event, doubleClick);
        if (!b && this.search.isFocused() && !this.search.autoComplete().mouseClicked(event, doubleClick)) {
            this.setFocused(null);
            this.clearFocus();
            b = true;
        }
        return b;
    }

    public boolean mouseScrolled(double xpos, double ypos, double xDelta, double yDelta) {
        if (this.search.autoComplete().mouseScrolled(xpos, ypos, xDelta, yDelta)) {
            return true;
        }
        return super.mouseScrolled(xpos, ypos, xDelta, yDelta);
    }

    public boolean keyPressed(KeyEvent event) {
        if (!this.search.isFocused() && this.selectedKey == null && event.hasControlDown() && event.key() == 70) {
            this.search.setFocused(true);
            return true;
        }
        if (this.search.isFocused() && event.isEscape()) {
            this.search.setFocused(false);
            return true;
        }
        if (this.selectedKey != null) {
            Services.PLATFORM.handleKeyPress(this, this.options, event);
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean keyReleased(KeyEvent event) {
        if (Services.PLATFORM.handleKeyReleased(this, this.options, event)) {
            return true;
        }
        return super.keyReleased(event);
    }

    private CustomList getCustomList() {
        KeyBindsList keyBindsList = this.getKeyBindsList();
        if (keyBindsList instanceof CustomList) {
            CustomList cl = (CustomList)keyBindsList;
            return cl;
        }
        throw new IllegalStateException("keyBindsList('%s') was not an instance of CustomList! You're either too early or another mod is messing with things.".formatted(this.getKeyBindsList().getClass()));
    }

    public KeyBindsList getKeyBindsList() {
        return this.getAccess().controlling$getKeyBindsList();
    }

    public AccessAbstractSelectionList getAbstractSelectionList() {
        return (AccessAbstractSelectionList)this.getKeyBindsList();
    }

    private void setKeyBindsList(KeyBindsList newList) {
        this.getAccess().controlling$setKeyBindsList(newList);
        this.repositionElements();
    }

    private AccessKeyBindsScreen getAccess() {
        return (AccessKeyBindsScreen)((Object)this);
    }

    private boolean canReset() {
        for (KeyMapping key : this.options.keyMappings) {
            if (key.isDefault()) continue;
            return true;
        }
        return false;
    }
}

